<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');
$routes->get('/main/about', 'Home::about');
$routes->get('/main/services', 'Home::services');
$routes->get('/main/blogs', 'Home::blogs');
$routes->get('/main/detail/(:num)', 'Home::detail/$1');
$routes->get('/main/events', 'Home::events');
$routes->get('/main/eventDetail/(:num)', 'Home::eventDetail/$1');
$routes->get('/main/gallery', 'Home::gallery');
$routes->get('/main/members', 'Home::members');
$routes->post('/main/storeMember', 'Home::storeMember');
$routes->get('/main/contact', 'Home::contact');
$routes->post('/main/storeUser', 'Home::storeUser');



//admin
// $routes->get('admin/getCarouselsAjax', 'Admin::getCarouselsAjax');
$routes->get('admin/carousel/list', 'Admin::list');

$routes->get('/admin/carousel', 'Admin::index');
$routes->get('/admin/index', 'Admin::index');
$routes->get('/admin/carousel/create', 'Admin::create');
$routes->post('/admin/carousel/store', 'Admin::store');
$routes->get('/admin/carousel/edit/(:num)', 'Admin::edit/$1');
$routes->post('/admin/carousel/update', 'Admin::update');

$routes->delete('admin/carousel/delete/(:num)', 'Admin::delete/$1');
$routes->get('/admin/carousel/delete/(:num)', 'Admin::delete/$1');
$routes->post('/admin/carousel/delete/(:num)', 'Admin::delete/$1');
$routes->get('/admin/carousel/delete', 'Admin::delete');
$routes->post('admin/carousel/delete', 'Admin::delete');

$routes->post('admin/toggleStatus/(:segment)/(:num)', 'Admin::toggleStatus/$1/$2');

$routes->get('/admin/dashboard', 'Admin::dashboard');

$routes->get('/admin/blog/blog-post', 'Admin::blog');
$routes->get('/admin/blog/createBlog', 'Admin::createBlog');
$routes->post('/admin/blog/storeBlog', 'Admin::storeBlog');
$routes->get('admin/blog/editBlog/(:num)', 'Admin::editBlog/$1');
$routes->get('/admin/blog/deleteBlog/(:num)', 'Admin::deleteBlog/$1');
$routes->get('/admin/blog/deleteBlog', 'Admin::deleteBlog');
$routes->post('/admin/blog/updateBlog', 'Admin::updateBlog');
$routes->post('admin/carousel/update/(:num)', 'Admin::update/$1');

$routes->get('/admin/event/manage-event', 'Admin::event');
$routes->get('/admin/event/createEvent', 'Admin::createEvent');
$routes->post('/admin/event/storeEvent', 'Admin::storeEvent');
$routes->get('admin/event/editEvent/(:num)', 'Admin::editEvent/$1');
$routes->get('/admin/event/deleteEvent/(:num)', 'Admin::deleteEvent/$1');
$routes->get('/admin/event/deleteEvent', 'Admin::deleteEvent');
$routes->post('/admin/event/updateEvent', 'Admin::updateEvent');

$routes->get('/admin/manage-members', 'Admin::members');
$routes->get('/admin/manage-members/(:num)', 'Admin::deleteMember/$1');
$routes->get('/admin/updateMember', 'Admin::updateMember');
$routes->post('/admin/updateMember', 'Admin::updateMember');
$routes->get('/admin/deleteMember/(:num)', 'Admin::deleteMember/$1');
$routes->delete('admin/deleteMember/(:num)', 'Admin::deleteMember/$1');
$routes->post('admin/deleteMember/(:num)', 'Admin::deleteMember/$1');


$routes->get('/admin/manage-users', 'Admin::users');
$routes->get('/admin/users', 'Admin::users');
$routes->get('admin/deleteUser/(:num)', 'Admin::deleteUser/$1');
$routes->get('/admin/manage-users/(:num)', 'Admin::deleteUser/$1');
$routes->post('/admin/deleteUser', 'Admin::deleteUser');
$routes->get('/admin/deleteUser', 'Admin::deleteUser');
$routes->delete('/admin/deleteUser', 'Admin::deleteUser');

$routes->get('/admin/manage-gallery/(:num)', 'Admin::deleteGallery/$1');
$routes->get('/admin/manage-gallery', 'Admin::gallery');
$routes->post('/admin/storeGallery', 'Admin::storeGallery');
$routes->post('/admin/fetchGalleryImages', 'Admin::fetchGalleryImages');
$routes->post('/admin/deleteGalleryImage','Admin::deleteGalleryImage');
$routes->post('/admin/updateGallery', 'Admin::updateGallery');
$routes->delete('/admin/deleteGallery', 'Admin::deleteGallery');

$routes->get('/admin/profile', 'Admin::profile');
$routes->post('admin/updateProfile', 'Admin::updateProfile');
$routes->post('admin/changePassword', 'Admin::changePassword');

$routes->get('/admin/login', 'Admin::login');
$routes->post('admin/login', 'Admin::handleLogin');