<?php

namespace App\Controllers;

use App\Models\CarouselModel;
use App\Models\BlogModel;
use App\Models\EventModel;
use App\Models\MemberModel;
use App\Models\UserModel;
use App\Models\GalleryModel;
use CodeIgniter\Validation\Exceptions\ValidationException;


class Home extends BaseController
{
    public function index()
    {
        $carouselModel = new CarouselModel();
        $blogModel = new BlogModel();
        $eventModel = new EventModel();
        $galleryModel = new GalleryModel();

        //load carousel image
        $data['slides'] = $carouselModel
        ->where('status', 'publish')
        ->orderBy('date', 'DESC')
        ->findAll();
        
        $eventModel = new EventModel();
        $data['events'] = $eventModel->where('status', 'Publish')->orderBy('date', 'DESC')->findAll();

        $blogModel = new BlogModel();
        $data['posts'] = $blogModel->where('status', 'Publish')->orderBy('date', 'DESC')->findAll();

        $galleryModel = new GalleryModel();
        $data['galleries'] = $galleryModel->orderBy('sno', 'DESC')->findAll();


        return view('main/index', $data);
    }

    public function about()
    {
        return view('main/about');
    }

    public function services()
    {
        return view('main/services');
    }

    public function blogs()
    {
        $blogModel = new BlogModel();
        $data['posts'] = $blogModel->where('status', 'Publish')->orderBy('sno', 'DESC')->findAll();
        return view('main/blogs', $data);
    }

    public function detail($id = null)
    {
        $blogModel = new BlogModel();

        if ($id === null) {
            // maybe redirect or show error if no ID is provided
            return redirect()->to('/blogs');
        }

        $post = $blogModel->where('status', 'Publish')->find($id);

        if (!$post) {
            // Post not found - show 404 or redirect
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Post not found");
        }

        // Pass the single post to the view
        $data['post'] = $post;

        return view('main/detail', $data);
    }

    public function events()
    {
        $eventModel = new EventModel();
        $data['events'] = $eventModel->where('status', 'Publish')->orderBy('sno', 'DESC')->findAll();
        return view('main/events', $data);
    }

    public function eventDetail($id = null)
    {
        $eventModel = new EventModel();

        if ($id === null) {
            return redirect()->to('/events');
        }

        $event = $eventModel->where('status', 'Publish')->find($id);

        if (!$event) {
            // Post not found - show 404 or redirect
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Event not found");
        }

        // Pass the single post to the view
        $data['event'] = $event;
        return view('main/eventDetail', $data);
    }

    public function members()
    {   
        return view('main/members');
    }

    public function storeMember()
    {
        $memberModel = new MemberModel();

        $data = [
            'first_name' => $this->request->getPost('first_name'),
            'last_name'  => $this->request->getPost('last_name'),
            'date'       => $this->request->getPost('date'),
            'email'      => $this->request->getPost('email'),
            'phone'      => $this->request->getPost('phone'),
            'address'    => $this->request->getPost('address'),
            'created_at' => date('Y-m-d H:i:s')
        ];

        $memberModel->insert($data);

        return redirect()->to('/main/members');
    }

    public function contact()
    {
        return view('main/contact');
    }

    public function storeUser()
    {
        $validation = \Config\Services::validation();

        $rules = [
            'name'    => 'required',
            'email'   => 'required|valid_email',
            'phone'   => 'required',
            'subject' => 'required',
            'message' => 'required'
        ];

        if (!$this->validate($rules)) {
            return view('main/contact', [
                'validation' => $this->validator
            ]);
        }

        $userModel = new UserModel();

        $data = [
            'name' => $this->request->getPost('name'),
            'email'  => $this->request->getPost('email'),
            'phone'  => $this->request->getPost('phone'),
            'subject' => $this->request->getPost('subject'),
            'message' => $this->request->getPost('message'),
            'created_at' => date('Y-m-d H:i:s')
        ];

        $userModel->insert($data);

        return redirect()->to('/main/contact');
    }

    public function gallery()
    {
        $galleryModel = new GalleryModel();
        $data['galleries'] = $galleryModel->orderBy('sno', 'DESC')->findAll();

        return view('main/gallery', $data);
    }

    
}

