<?= $this->include('admin/templates/header') ?>

<div class="d-flex justify-content-between align-self-center mt-5">
    <div class="pagetitle">
        <h1 tabindex="-1">Manage Carousel</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="admin/dashboard">Home</a>
                </li>
                <li class="breadcrumb-item active">Carousels</li>
            </ol>
        </nav>
    </div>
    <div class="actions-btns d-flex align-items-center mb-3">
        <button class="btn btn-sm btn-primary" data-enhance-nav="false" fdprocessedid="ac4auo" data-bs-toggle="modal" data-bs-target="#exampleModal">
            <i class="fa fa-plus"></i> New Carousel
        </button>
    </div>
</div>

<div id="spinner" style="background-color: rgba(0, 0, 0, 0.6);" class=" w-100 vh-100 position-fixed translate-middle top-50 start-50  d-flex align-items-center justify-content-center">
    <div class="spinner-grow text-primary" role="status"></div>
</div>

<form id="filterForm">
    <div class="row d-flex justify-content-between mb-2">
        <div class="col-4">
            <div class="form-outline">
                <div class="input-group">
                    <input type="text" name="search" placeholder="Search by Title, Sub-title" class="form-control form-control-sm">
                    <button class="btn btn-primary" type="submit">
                        <i class="fa fa-search" style="color:white"></i>
                    </button>
                </div>
            </div>
        </div>

        <div class="col-8 d-flex justify-content-end">
            <div class="col-3">
                <div class="input-group">
                    <span class="input-group-text bg-primary">
                        <i class="bi bi-funnel" style="color:white"></i>
                    </span>
                    <select class="form-select" name="status">
                        <option value="">All</option>
                        <option value="Publish">Published</option>
                        <option value="Unpublish">Unpublished</option>
                    </select>
                </div>
            </div>
            &nbsp; &nbsp;
            <div class="col-3 align-self-end">
                <div class="form-outline">
                    <div class="input-group">
                        <input type="date" name="searchDate" class="form-control">
                        <button class="btn btn-primary" type="submit">
                            <i class="fa fa-search" style="color:white"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<table class="table datatable table-hover table-striped table-responsive shadow-lg mt-1" id="carouselTable">
    <thead>
        <tr>
            <th>Sr No.</th>
            <th>Carousel Image</th>
            <th>Title</th>
            <th>Sub Title </th>
            <th>Date </th>
            <th>Description </th>
            <th>Status</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        
    </tbody>
</table>

<div class="pagination-container">
    <nav aria-label="Page navigation">
        <ul class="pagination justify-content-end">

        </ul>
    </nav>
</div>

<!-- Delete Carousel -->
<div style="z-index:99999" class="modal fade" id="deleteCarousel" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="deleteModalLabel">Delete Carousel</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete '<span id="delete-carousel-title"></span>' carousel?</p>
                <input type="hidden" id="delete-carousel-id">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="confirm-delete-btn">Delete</button>
            </div>
        </div>
    </div>
</div>

<!-- New Carousel -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Add Carousel</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form data-enhance="" action="<?= base_url('admin/carousel/store') ?>" id="addCarouselForm" method="post" enctype="multipart/form-data">
                    <div data-mdb-input-init="" class="form-outline mb-4">
                        <label class="form-label">Carousel Title</label>
                        <input class="form-control form-control-sm valid" name="title">
                    </div>

                    <div data-mdb-input-init="" class="form-outline mb-4">
                        <label class="form-label">Carousel Sub Title</label>
                        <input class="form-control form-control-sm valid" name="sub-title">
                    </div>

                    <div data-mdb-input-init="" class="form-outline mb-4">
                        <label class="form-label">Carousel Description</label>
                        <textarea class="form-control form-control-sm valid" name="description"></textarea>
                        <!-- <input class="form-control form-control-sm valid" name="description"> -->
                    </div>

                    <div data-mdb-input-init="" class="form-outline mb-4">
                        <input type="checkbox" class="form-check-input valid" name="status" > Published
                    </div>

                    <div data-mdb-input-init="" class="form-outline mb-4">
                        <label class="form-label">Carousel Image</label>
                        <input accept="image/*" class="small form-control form-control-sm" name="image" type="file">
                    </div>

                    <div class="text-end align-content-center">
                        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary btn-sm">Add Carousel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Edit Carousel -->
<div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form id="editCarouselForm" method="post" enctype="multipart/form-data">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="editModalLabel">Update Carousel</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="sno" id="edit-sno">

                    <div class="form-outline mb-3">
                        <label class="form-label">Title</label>
                        <input type="text" class="form-control form-control-sm" name="title" id="edit-title">
                    </div>

                    <div class="form-outline mb-3">
                        <label class="form-label">Sub Title</label>
                        <input type="text" class="form-control form-control-sm" name="sub-title" id="edit-sub-title">
                    </div>

                    <div class="form-outline mb-3">
                        <label class="form-label">Description</label>
                        <textarea class="form-control form-control-sm" name="description" id="edit-description"></textarea>
                        <!-- <input type="text" class="form-control form-control-sm" name="description" id="edit-description"> -->
                    </div>

                    <div class="form-check mb-3">
                        <input type="checkbox" class="form-check-input" name="status" id="edit-status">
                        <label class="form-check-label">Published</label>
                    </div>

                    <div class="form-outline mb-3">
                        <label class="form-label">Carousel Image</label>
                        <input type="file" class="form-control form-control-sm" name="image">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary btn-sm">Update Carousel</button>
                </div>
            </div>
        </form>
    </div>
</div>

<?= $this->include('admin/templates/footer') ?>