<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <base href="/">
    <meta name="description" content="SRG Foundations collectively making a small effort to preserve this invaluable heritage of indigenous cattle, a symbol of Sanatan Dharma, and a national treasure of undivided India.">
    <meta name="author" content="Wind Hans Technologies">
    <link rel="icon" type="image/png" sizes="40x40" href="<?= base_url('/upload/admin/favicon.png') ?>">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://kit.fontawesome.com/c20abdb703.js" crossorigin="anonymous"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="https://fonts.googleapis.com/css2?family=Jost:wght@500;600&amp;family=Roboto&amp;display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700&amp;display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="/styles.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.snow.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.9.0/highlight.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.js"></script>
    <link
      rel="stylesheet"
      href="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.9.0/styles/atom-one-dark.min.css"
    />
    <script src="https://cdn.jsdelivr.net/npm/katex@0.16.9/dist/katex.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/katex@0.16.9/dist/katex.min.css" />
    <link rel="stylesheet" href="<?= base_url('/assets/login.css') ?>">
    <title>Login</title>
</head>
<body>

<div id="app">
    <div class="page" b-iozxchoxo3="">
        <main b-iozxchoxo3="">
            <div id="spinner" style="display: none; background-color: rgba(0, 0, 0, 0.6);" class=" w-100 vh-100 position-fixed translate-middle top-50 start-50  d-flex align-items-center justify-content-center">
                <div class="spinner-grow text-primary" role="status"></div>
            </div>

            <div class="background-image"></div>

            <div class="container-wrapper">
                <div class="login-container">
                    <h1 class="text-center" tabindex="-1">Login</h1>
                    <form method="post" action="<?= base_url('admin/login') ?>">
                        <h5>Use admin credentials to log in.</h5>
                        <hr>
    
                        <!-- Show validation errors -->
                        <?php if (session()->getFlashdata('error')): ?>
                            <div class="alert alert-danger">
                                <?= session()->getFlashdata('error') ?>
                            </div>
                        <?php endif; ?>

                        <div class="mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input 
                                type="email" 
                                name="email" 
                                id="email"
                                autocomplete="username"
                                placeholder="name@example.com" 
                                class="form-control <?= session('errors.email') ? 'is-invalid' : '' ?>" 
                                value="<?= old('email') ?>"
                            >
                            <?php if (session('errors.email')): ?>
                                <div class="invalid-feedback"><?= session('errors.email') ?></div>
                            <?php endif; ?>
                        </div>

                        <div class="mb-3">
                            <label for="password" class="form-label">Password</label>
                            <input 
                                type="password" 
                                name="password" 
                                id="password"
                                autocomplete="current-password" 
                                placeholder="password" 
                                class="form-control <?= session('errors.password') ? 'is-invalid' : '' ?>"
                            >
                            <?php if (session('errors.password')): ?>
                                <div class="invalid-feedback"><?= session('errors.password') ?></div>
                            <?php endif; ?>
                        </div>

                        <div>
                            <button style="border-radius:10px;" type="submit" class="w-100 btn btn-lg btn-primary">Log in</button>
                        </div>
                    </form>

                </div>
            </div>
        </main>
    </div>
</div>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<?php if (session()->getFlashdata('login_error')): ?>
<script>
    Swal.fire({
        icon: 'error',
        title: 'Login Failed!',
        text: '<?= session()->getFlashdata('login_error') ?>',
        timer: 1600,
        timerProgressBar: false,
        showConfirmButton: false
    });
</script>
<?php endif; ?>
</body>
</html>