<?= $this->include('admin/templates/header') ?>

<div class="d-flex justify-content-between align-self-center mt-5">
    <div class="pagetitle">
        <h1 tabindex="-1">Manage Gallery</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="admin/dashboard">Home</a>
                </li>
                <li class="breadcrumb-item active">gallery</li>
            </ol>
        </nav>
    </div>
    <div class="actions-btns d-flex align-items-center mb-3">
        <button class="btn btn-sm btn-primary" data-enhance-nav="false" fdprocessedid="ac4auo" data-bs-toggle="modal" data-bs-target="#exampleModal">
            <i class="fa fa-plus"></i> New Gallery
        </button>
    </div>
</div>

<div id="spinner" style="background-color: rgba(0, 0, 0, 0.6);" class=" w-100 vh-100 position-fixed translate-middle top-50 start-50  d-flex align-items-center justify-content-center">
    <div class="spinner-grow text-primary" role="status"></div>
</div>

<form id="filterForm">
    <div class="row d-flex justify-content-between mb-2">
        <div class="col-4">
            <div class="form-outline">
                <div class="input-group">
                    <input type="text" name="search" placeholder="Search by Gallery Name, Category" class="form-control form-control-sm">
                    <button class="btn btn-primary" fdprocessedid="lj4">
                        <i class="fa fa-search" style="color:white"></i>
                    </button>
                </div>
            </div>
        </div>

        <div class="col-8 d-flex justify-content-end">
            <div class="col-3 align-self-end">
                <div class="form-outline">
                    <div class="input-group">
                        <input type="date" name="searchDate" class="form-control form-control" _bl_3="">
                        <button class="btn btn-primary">
                            <i class="fa fa-search" style="color:white"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<table id="galleryTable" class="table datatable table-hover table-striped table-responsive shadow-lg mt-1">
    <thead>
        <tr>
            <th>Sr No.</th>
            <th>Gallery Name </th>
            <th>Category </th>
            <th>Date </th>
            <th>Images</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>

    </tbody>
</table>

<!-- pagination -->
<div class="pagination-container">
    <nav aria-label="Page navigation">
        <ul class="pagination justify-content-end">

        </ul>
    </nav>
</div>

<!-- delete gallery -->
<div style="z-index:99999" class="modal fade" id="deleteGallery" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="deleteModalLabel">Delete </h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete this '<span id="delete-gallery-title"></span>' gallery?</p>
                <input type="hidden" id="delete-gallery-id">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="confirm-delete-btn">Delete</button>
            </div>
        </div>
    </div>
</div>

<!-- Gallery View -->
<div class="modal fade" id="galleryModal" tabindex="-1" aria-labelledby="galleryModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="galleryModalLabel">Cow Care Gallery</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="row">
          <!-- Images will be loaded dynamically here -->
        </div>
      </div>
    </div>
  </div>
</div>

<!-- New Gallery -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" style="display: none;" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Add Gallery</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="<?= base_url('/admin/storeGallery') ?>" method="post" enctype="multipart/form-data">
                    <div data-mdb-input-init="" class="form-outline mb-4">
                        <label class="form-label">Gallery Name</label>
                        <input class="form-control form-control-sm valid" name="name">
                    </div>

                    <div data-mdb-input-init="" class="form-outline mb-4">
                        <label class="form-label">Category</label>
                        <input class="form-control form-control-sm valid" name="category">
                    </div>

                    <div data-mdb-input-init="" class="form-outline mb-4">
                        <label class="form-label">Created Date</label>
                        <input type="date" class="form-control form-control-sm valid" name="date">
                    </div>

                    <div data-mdb-input-init="" class="form-outline mb-4">
                        <label class="form-label">Add Image</label>
                        <input accept="image/*" class="form-control form-control-sm" type="file" name="image[]" multiple>
                    </div>

                    <div class="text-end align-content-center">
                        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary btn-sm">Add Gallery</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Edit Gallery Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="editGalleryForm" method="post" enctype="multipart/form-data">
                <input type="hidden" name="sno" id="editGalleryId">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel">Edit Gallery</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-outline mb-3">
                        <label class="form-label">Gallery Name</label>
                        <input type="text" name="name" id="editName" class="form-control form-control-sm" >
                    </div>
                    <div class="form-outline mb-3">
                        <label class="form-label">Category</label>
                        <input type="text" name="category" id="editCategory" class="form-control form-control-sm">
                    </div>
                    <div class="form-outline mb-3">
                        <label class="form-label">Date</label>
                        <input type="date" name="date" id="editDate" class="form-control form-control-sm">
                    </div>
                    <div class="form-outline mb-3">
                        <label class="form-label">Update Images</label>
                        <input type="file" name="image[]" class="form-control form-control-sm" multiple>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary btn-sm">Update Gallery</button>
                </div>
            </form>
        </div>
    </div>
</div>



<?= $this->include('admin/templates/footer') ?>