<?= $this->include('admin/templates/header') ?>

<div class="d-flex justify-content-between align-self-center mt-5">
    <div class="pagetitle">
        <h1 tabindex="-1">Profile</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="admin/dashboard">Home</a>
                </li>
                <li class="breadcrumb-item active">Profile</li>
            </ol>
        </nav>
    </div>
    <div class="actions-btns d-flex align-items-center mb-3"></div>
</div>

<div id="spinner" style="background-color: rgba(0, 0, 0, 0.6);" class=" w-100 vh-100 position-fixed translate-middle top-50 start-50  d-flex align-items-center justify-content-center">
    <div class="spinner-grow text-primary" role="status"></div>
</div>

<div class="section profile">
    <?php if(session()->getFlashdata('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?= session()->getFlashdata('success') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <?php if(session()->getFlashdata('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?= session()->getFlashdata('error') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <?php if(session('errors')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <ul class="mb-0">
                <?php foreach(session('errors') as $error): ?>
                    <li><?= esc($error) ?></li>
                <?php endforeach; ?>
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>


    <div class="row">
        <div class="col-xl-4">
            <div class="card">
                <div class="card-body profile-card pt-4 d-flex flex-column align-items-center">
                    <img src="<?= base_url('/uploads/SRGLogo.jpg') ?>" alt="Profile" class="rounded-circle">
                    <h2>Admin</h2>
                    <h3>Gaushala Owner</h3>
                </div>
            </div>
        </div>
        <div class="col-xl-8">
            <div class="card">
                <div class="card-body pt-3">
                    <ul class="nav nav-tabs nav-tabs-bordered" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#profile-edit" aria-selected="true" tabindex="-1" role="tab">Edit Profile</button>
                        </li>

                        <li class="nav-item" role="presentation">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#profile-change-password" aria-selected="false" role="tab" tabindex="-1">Change Password</button>
                        </li>
                    </ul>
                    <div class="tab-content pt-2">
                        <div class="tab-pane fade profile-edit pt-3 active show" id="profile-edit" role="tabpanel">

                            <form action="<?= base_url('admin/updateProfile') ?>" method="post" enctype="multipart/form-data">
                                
                                <div class="row mb-3">
                                    <label for="fullName" class="col-md-4 col-lg-3 col-form-label">Full Name</label>
                                    <div class="col-md-8 col-lg-9">
                                        <input type="text" name="fullname" id="fullName" class="form-control valid" value="<?= esc($profile['fullname'])?>">
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <label for="Email" class="col-md-4 col-lg-3 col-form-label">Email</label>
                                    <div class="col-md-8 col-lg-9">
                                        <input type="email" id="Email" name="email" class="form-control valid" value="<?=esc($profile['email'])?>">
                                    </div>
                                </div>
                                <div class="text-center">
                                    <button type="submit" id="saveChange" class="btn btn-primary">Save Changes</button>
                                </div>
                            </form>
                        </div>

                        <div class="tab-pane fade pt-3" id="profile-change-password" role="tabpanel">
                            <form action="<?= base_url('admin/changePassword') ?>" method="post" enctype="multipart/form-data">
                                <div class="row mb-3">
                                    <label for="currentPassword" class="col-md-4 col-lg-3 col-form-label">Current Password</label>
                                    <div class="col-md-8 col-lg-9 p-0 position-relative">
                                        <input type="password" id="currentPassword" required="" name="password" class="form-control valid">
                                        <button type="button" class="btn btn-link position-absolute end-0 toggle-password" style="top: 50%; transform: translateY(-50%);">
                                            <i class="bi bi-eye-slash"></i>
                                        </button>
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <label for="newPassword" class="col-md-4 col-lg-3 col-form-label">New Password</label>
                                    <div class="col-md-8 col-lg-9 p-0 position-relative">
                                        <input type="password" id="newPassword" required="" name="newpassword" class="form-control valid" _bl_46="">
                                        <button type="button" class="btn btn-link position-absolute end-0 toggle-password" style="top: 50%; transform: translateY(-50%);">
                                            <i class="bi bi-eye-slash"></i>
                                        </button>
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <label for="renewPassword" class="col-md-4 col-lg-3 col-form-label">Re-enter New Password</label>
                                    <div class="col-md-8 col-lg-9 p-0 position-relative">
                                        <input type="password" id="renewPassword" required="" name="renewpassword" class="form-control valid" _bl_47="">
                                        <button type="button" class="btn btn-link position-absolute end-0 toggle-password" style="top: 50%; transform: translateY(-50%);">
                                            <i class="bi bi-eye-slash"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="text-center">
                                    <button type="submit" class="btn btn-primary">Change Password</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<?= $this->include('admin/templates/footer') ?>