  </main>
  
  <div id="footer" class="footer text-center">
    <div class="copyrightt">
      © Copyright <strong>
      <span>Shree Rajlaxmi Gaushala</span></strong>. All Rights Reserved
    </div>
    <div class="credits">
      Designed by <a href="https://windhans.com/">Wind Hans Technologies</a>
    </div>
  </div>
  <a href="#" class="back-to-top d-flex align-items-center justify-content-center" style="display: none">
    <i class="bi bi-arrow-up-short"></i>
  </a>
  </div>
</div>

<script>
  document.addEventListener("DOMContentLoaded", function () {
    const toggleBtn = document.querySelector('.toggle-sidebar-btn');
    const body = document.body;

    toggleBtn.addEventListener('click', function () {
      body.classList.toggle('toggle-sidebar'); // This class controls sidebar visibility
    });
  });
</script>

<!-- delete carousel -->
<script>
  document.addEventListener('DOMContentLoaded', function () {
      const deleteButtons = document.querySelectorAll('.btn-delete-carousel');
      const deleteTitle = document.getElementById('delete-carousel-title');
      const deleteId = document.getElementById('delete-carousel-id');
      const confirmDeleteBtn = document.getElementById('confirm-delete-btn');

      document.getElementById('carouselTable').addEventListener('click', function (e) {
        if (e.target.closest('.btn-delete-carousel')) {
          const btn = e.target.closest('.btn-delete-carousel');
          const id = btn.getAttribute('data-id');
          const title = btn.getAttribute('data-title');
          deleteTitle.textContent = title;
          deleteId.value = id;
        }
      });


      confirmDeleteBtn.addEventListener('click', function () {
        const id = deleteId.value.trim();
        if (!id) {
          alert("No carousel ID selected.");
          return;
        }
        const url = `<?= base_url('admin/carousel/delete') ?>/${id}`;

        console.log("Resolved delete URL:",url);

        fetch(url, {
          method: 'POST',
          headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Content-Type': 'application/json',
            'Accept': 'application/json',
          },
           body: JSON.stringify({ _method: 'DELETE' })
        })
        .then(response => response.json())
        .then(data => {
          if (data.status === 'success') {
            $('#deleteCarousel').modal('hide');
            $('#carouselTable').DataTable().ajax.reload(null, false);
          } else {
            alert(data.message || 'Delete failed');
          }
        })
        .catch(error => {
          console.error('AJAX Delete Error:', error);
          alert('Something went wrong.');
        });

      });
  });
</script>

<!-- Add carousel -->
<script>
  document.addEventListener('DOMContentLoaded', function () {
    // ADD CAROUSEL
    const addForm = document.getElementById('addCarouselForm');
    addForm.addEventListener('submit', function (e) {
      e.preventDefault();

      const formData = new FormData(addForm);

      fetch("<?= base_url('admin/carousel/store') ?>", {
        method: "POST",
        headers: {
          "X-Requested-With": "XMLHttpRequest"  // important!
        },
        body: formData
      })
      .then(res => res.json())
      .then(data => {
        if (data.status === 'success') {
          $('#exampleModal').modal('hide');
          $('#carouselTable').DataTable().ajax.reload(null, false);
          addForm.reset();
        } else {
          alert(data.message || 'Failed to add carousel');
        }
      })
      .catch(err => {
        console.error('Add Error:', err);
        alert('Something went wrong.');
      });
    });
  });
</script>

<!-- Datatable Carousel -->
<script>
  let triggerSource = 'pagination';

  let currentPage = 1;
  const pageLength = 10;
  let totalPages = 1;

  $(document).ready(function () {
  const table = $('#carouselTable').DataTable({
    processing: true,
    serverSide: true,
    paging: false,
    searching: false,
    info: false,
    ajax: {
      url: "<?= base_url('admin/carousel/list') ?>",
      type: "GET",
      data: function (d) {
        // d.search = {
        //   value: $('input[name="search"]').val()
        // };
        const searchVal = $('input[name="search"]').val();
        const searchDate = $('input[name="searchDate"]').val();
        const status = $('select[name="status"]').val();

        d.columns[2].search.value = searchVal; // title
        d.columns[3].search.value = searchVal; // subtitle
        d.columns[5].search.value = searchVal; // description
        d.searchDate = searchDate;
        d.status = status;

        d.search.value = ''; 
        d.page = currentPage;
        d.length = pageLength;

        console.log('Filter Data Sent:', d);
      },
      error: function (xhr) {
        console.error('Ajax error:', xhr.responseText);
      }
    },
    columns: [
      { data: null, render: (data, type, row, meta) => meta.row + 1 + ((currentPage - 1) * pageLength), orderable: false, searchable: false},
      { data: 'carousel_image', orderable: false, searchable: false, render: function (data) {
          return `<img src="${data}" style="max-width:100px; max-height:100px;">`;
      }},
      { data: 'title',orderable: true , searchable: true },
      { data: 'subtitle',orderable: true },
      { data: 'created_at',orderable: true },
      { data: 'description',orderable: true },
      { data: 'status', orderable: false, searchable: false },
      { data: 'action', orderable: false, searchable: false }
    ],
      drawCallback: function (settings) {
          updatePaginationUI(settings.json);
          updateSortIcons(settings.json?.order);
          if (triggerSource === 'pagination' || triggerSource === 'initial') {
            $('#spinner').show(); 
          } else {
            $('#spinner').hide(); 
          }

          setTimeout(() => {
            $('#spinner').hide();
            updatePaginationUI(settings.json);
            updateSortIcons(settings.json?.order);
          }, 100); 
        }
    });

    $('#filterForm').on('submit', function (e) {
      e.preventDefault();
      currentPage = 1;
      table.ajax.reload();
    });

    $('select[name="status"], input[name="searchDate"]').on('change', function () {
      currentPage = 1;
      table.ajax.reload();
    });

    $(document).on('click', '.pagination .page-link', function (e) {
      e.preventDefault();
      const target = $(this);
      if (target.parent().hasClass('disabled') || target.parent().hasClass('active')) return;

      if (target.attr('id') === 'prevPage' && currentPage > 1) currentPage--;
      else if (target.attr('id') === 'nextPage' && currentPage < totalPages) currentPage++;
      else {
        const page = parseInt(target.data('page'));
        if (page) currentPage = page;
      }

      table.ajax.reload();
    });
  });

  function updateSortIcons(serverOrder) {
    $('#carouselTable thead th').each(function (index) {
      const $th = $(this);
      $th.find('i.bi').remove();

      if (index === 0) return; // Skip S.No. column

      if (serverOrder && parseInt(serverOrder.column) === index) {
        const direction = serverOrder.dir;
        const icon = direction === 'asc' ? 'bi-sort-up' : 'bi-sort-down';
        $th.append(`<i class="bi ${icon}" style="margin-left:5px;"></i>`);
      } 
      // else {
      //   $th.append('<i class="bi bi-arrow-down-up" style="margin-left:5px;"></i>');
      // }
    });
  }

  function updatePaginationUI(json) {
    const paginationUL = $('.pagination');
    paginationUL.empty();

    const totalRecords = json.recordsFiltered || 0;
    totalPages = Math.ceil(totalRecords / pageLength);

    paginationUL.append(`
      <li class="page-item ${currentPage === 1 ? 'disabled' : ''}">
        <a class="page-link" id="prevPage" style="cursor:pointer;">&laquo;</a>
      </li>
    `);

    const maxPagesToShow = 5;
    let startPage = Math.max(1, currentPage - 2);
    let endPage = Math.min(totalPages, startPage + maxPagesToShow - 1);

    if (endPage - startPage < maxPagesToShow - 1) {
      startPage = Math.max(1, endPage - maxPagesToShow + 1);
    }

    for (let i = startPage; i <= endPage; i++) {
      paginationUL.append(`
        <li class="page-item ${i === currentPage ? 'active' : ''}">
          <a class="page-link" data-page="${i}" style="cursor:pointer;">${i}</a>
        </li>
      `);
    }

    paginationUL.append(`
      <li class="page-item ${currentPage === totalPages ? 'disabled' : ''}">
        <a class="page-link" id="nextPage" style="cursor:pointer;">&raquo;</a>
      </li>
    `);
  }

</script>

<!-- edit carousel -->
<script>
  // Delegated event listener
  document.addEventListener('click', function (e) {
    if (e.target.closest('.btn-edit-carousel')) {
      const button = e.target.closest('.btn-edit-carousel');

      console.log("RAW BUTTON HTML:", button.outerHTML);

      const sno = button.getAttribute('data-id');
      const title = button.getAttribute('data-title');
      const subtitle = button.getAttribute('data-subtitle');
      const description = button.getAttribute('data-description');
      const status = button.getAttribute('data-status');

      console.log("SNO:", sno);
      console.log("TITLE:", title);
      console.log("SUBTITLE:", subtitle);
      console.log("DESCRIPTION:", description);
      console.log("STATUS:", status);

      document.getElementById('edit-sno').value = sno || '';
      document.getElementById('edit-title').value = title || '';
      document.getElementById('edit-sub-title').value = subtitle || '';
      document.getElementById('edit-description').value = description || '';
      document.getElementById('edit-status').checked = (status || '').toLowerCase() === 'publish';

      document.getElementById('editCarouselForm').action = "<?= base_url('admin/carousel/update') ?>";
    }
  });

  // Submit form with Fetch API
  document.getElementById('editCarouselForm').addEventListener('submit', function (e) {
    e.preventDefault();

    const form = e.target;
    const formData = new FormData(form);

    if (typeof quill !== 'undefined') {
      formData.set('description', quill.root.innerHTML);
    }

    console.log("Submitting to:", form.action);
    console.log("FormData:", Object.fromEntries(formData.entries()));

    fetch(form.action, {
      method: 'POST',
      headers: {
        'X-Requested-With': 'XMLHttpRequest'
      },
      body: formData
    })
      .then(res => res.json())
      .then(response => {
        if (response.status === 'success') {
          Swal.fire({
            title: 'Success',
            text: response.message,
            icon: 'success',
            showConfirmButton: false,
            timer: 1500
          }).then(() => {
            location.reload();
          });
        } else {
          Swal.fire({
            title: 'Error',
            text: response.message || 'Something went wrong.',
            icon: 'error',
            showConfirmButton: false,
            timer: 1500
          });
        }
      })
      .catch(error => {
        console.error("Submission Error:", error);
        Swal.fire({
          title: 'Error',
          text: 'An unexpected error occurred.',
          icon: 'error',
          showConfirmButton: false,
          timer: 1500
        });
      });
  });
</script>

<!-- Blog Datatable -->
<script>
  let blogCurrentPage = 1;
  const blogPageLength = 10;
  let blogTotalPages = 1;

  $(document).ready(function () {
    const blogTable = $('#blogTable').DataTable({
      processing: true,
      serverSide: true,
      paging: false,
      searching: false,
      info: false,
      ajax: {
        url: "<?= base_url('admin/blog/blog-post') ?>",
        type: "GET",
        data: function (d) {
          d.columns = [
            { data: 'sno' },
            { data: 'title' },
            { data: 'image' },
            { data: 'date' },
            { data: 'status' },
            { data: 'action' }
          ];

          d.search = {
            value: $('input[name="search"]').val()
          };
          d.status = $('select[name="status"]').val();
          d.searchDate = $('input[name="searchDate"]').val();
          d.page = blogCurrentPage;
          d.length = blogPageLength;

        }
      },
      columns: [
        { data: 'sno' }, 
        { data: 'title', orderable: true, searchable: true },
        { data: 'image', orderable: false, searchable: false },
        { data: 'date', orderable: true },
        { data: 'status', orderable: false, searchable: false },
        { data: 'action', orderable: false, searchable: false }
      ],
      drawCallback: function (settings) {
        updateBlogPagination(settings.json);
        updateSortIcons(settings.json?.order);

        if (triggerSource === 'pagination' || triggerSource === 'initial') {
            $('#spinner').show(); 
          } else {
            $('#spinner').hide(); 
          }

          setTimeout(() => {
            $('#spinner').hide();
            updateBlogPagination(settings.json);
            updateSortIcons(settings.json?.order);
          }, 100); 
      }
    });

    function updateSortIcons(serverOrder) {
      $('#blogTable thead th').each(function (index) {
        const $th = $(this);
        $th.find('i.bi').remove();

        if (index === 0) return; 

        if (serverOrder && parseInt(serverOrder.column) === index) {
          const direction = serverOrder.dir;
          const icon = direction === 'asc' ? 'bi-sort-up' : 'bi-sort-down';
          $th.append(`<i class="bi ${icon}" style="margin-left:5px;"></i>`);
        } 
        // else {
        //   $th.append('<i class="bi bi-arrow-down-up" style="margin-left:5px;"></i>');
        // }
      });
    }

    function updateBlogPagination(json) {
      const paginationUL = $('.pagination');
      paginationUL.empty();

      const totalRecords = json.recordsFiltered || 0;
      blogTotalPages = Math.ceil(totalRecords / blogPageLength);

      paginationUL.append(`
        <li class="page-item ${blogCurrentPage === 1 ? 'disabled' : ''}">
          <a class="page-link" id="blogPrevPage" style="cursor:pointer;">&laquo;</a>
        </li>
      `);

      const maxPagesToShow = 10;
      let startPage = Math.max(1, blogCurrentPage - 2);
      let endPage = Math.min(blogTotalPages, startPage + maxPagesToShow - 1);

      if (endPage - startPage < maxPagesToShow - 1) {
        startPage = Math.max(1, endPage - maxPagesToShow + 1);
      }

      for (let i = startPage; i <= endPage; i++) {
        paginationUL.append(`
          <li class="page-item ${i === blogCurrentPage ? 'active' : ''}">
            <a class="page-link blog-page-link" data-page="${i}" style="cursor:pointer;">${i}</a>
          </li>
        `);
      }

      paginationUL.append(`
        <li class="page-item ${blogCurrentPage === blogTotalPages ? 'disabled' : ''}">
          <a class="page-link" id="blogNextPage" style="cursor:pointer;">&raquo;</a>
        </li>
      `);
    }

    // Pagination click
    $(document).on('click', '.blog-page-link, #blogPrevPage, #blogNextPage', function (e) {
      e.preventDefault();
      const target = $(this);

      if (target.parent().hasClass('disabled') || target.parent().hasClass('active')) return;

      if (target.attr('id') === 'blogPrevPage' && blogCurrentPage > 1) {
        blogCurrentPage--;
      } else if (target.attr('id') === 'blogNextPage' && blogCurrentPage < blogTotalPages) {
        blogCurrentPage++;
      } else if (target.hasClass('blog-page-link')) {
        const page = parseInt(target.data('page'));
        if (page) blogCurrentPage = page;
      }

      $('#blogTable').DataTable().ajax.reload();
    });


    // Filters
    $('#filterForm').on('submit', function (e) {
      e.preventDefault();
      blogCurrentPage = 1;
      blogTable.ajax.reload();
    });

    $('input[name="search"], select[name="status"], input[name="searchDate"]').on('change keyup', function () {
      blogCurrentPage = 1;
      blogTable.ajax.reload();
    });
  });
</script>

<!-- delete blog -->
<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteButtons = document.querySelectorAll('.btn-delete-blog');
    const deleteTitle = document.getElementById('delete-blog-title');
    const deleteId = document.getElementById('delete-blog-id');
    const confirmDeleteBtn = document.getElementById('confirm-delete-btn');

    deleteButtons.forEach(btn => {
          btn.addEventListener('click', function () {
              const id = this.getAttribute('data-id');
              const title = this.getAttribute('data-title');
              deleteTitle.textContent = title;
              deleteId.value = id;
          });
    });

    confirmDeleteBtn.addEventListener('click', function () {
      const id = deleteId.value;
      window.location.href = `<?= base_url('admin/blog/deleteBlog') ?>/${id}`;
    });
  });
</script>

<!-- delete event -->
<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteButtons = document.querySelectorAll('.btn-delete-event');
    const deleteTitle = document.getElementById('delete-event-title');
    const deleteId = document.getElementById('delete-event-id');
    const confirmDeleteBtn = document.getElementById('confirm-delete-btn');

    deleteButtons.forEach(btn => {
      btn.addEventListener('click', function () {
        const id = this.getAttribute('data-id');
        const title = this.getAttribute('data-title');
        deleteTitle.textContent = title;
        deleteId.value = id;
      });
    });

    confirmDeleteBtn.addEventListener('click', function () {
      const id = deleteId.value;
        window.location.href = `<?= base_url('admin/event/deleteEvent') ?>/${id}`;
    });
  });
</script>

<!-- delete gallery -->
<script>
  $(document).ready(function () {
      let deleteId;

      // When delete button is clicked, set gallery name and id
      $(document).on('click', '.btn-delete-gallery', function () {
          deleteId = $(this).data('id');
          const galleryTitle = $(this).data('title');
          $('#delete-gallery-title').text(galleryTitle);
          $('#delete-gallery-id').val(deleteId);
      });

      // Confirm Delete AJAX
      $('#confirm-delete-btn').on('click', function () {
          const id = $('#delete-gallery-id').val();

          if (!id) return;

          // Show spinner
          $('#spinner').show();

          $.ajax({
              url: "<?= base_url('admin/deleteGallery') ?>",
              method: "DELETE",
              contentType: "application/json",
              data: JSON.stringify({ id: id }),
              success: function (response) {
                  $('#spinner').hide();

                  if (response.success) {
                      $('#deleteGallery').modal('hide');
                      Swal.fire({
                          icon: 'success',
                          title: 'Deleted!',
                          text: 'Gallery has been deleted.',
                          timer: 2000
                      });
                      $('#galleryTable').DataTable().ajax.reload(null, false);
                  } else {
                      Swal.fire({
                          icon: 'error',
                          title: 'Failed!',
                          text: response.message || 'Could not delete the gallery.'
                      });
                  }
              },
              error: function () {
                  $('#spinner').hide();
                  Swal.fire({
                      icon: 'error',
                      title: 'Error!',
                      text: 'Something went wrong. Please try again.'
                  });
              }
          });
      });
  });
</script>

<!-- quill -->
<script>
    var quill = new Quill('#editor', {
        theme: 'snow',
        placeholder: 'Enter Content',
        modules: {
            toolbar: '#toolbar-container'
        }
    });

    quill.root.innerHTML = document.querySelector('#description').value;

    document.querySelector('form').addEventListener('submit', function() {
        var content = document.querySelector('#description');
        content.value = quill.root.innerHTML;
    });
</script>

<!-- toggle eye -->
<script>
  document.querySelectorAll('.toggle-password').forEach(button => {
    button.addEventListener('click', () => {
      const input = button.previousElementSibling;
      const icon = button.querySelector('i');
      if (input.type === 'password') {
        input.type = 'text';
        icon.classList.remove('bi-eye-slash');
        icon.classList.add('bi-eye');
      } else {
        input.type = 'password';
        icon.classList.remove('bi-eye');
        icon.classList.add('bi-eye-slash');
      }
    });
  });
</script>

<!-- logout error -->
<script>
  document.getElementById('logoutBtn').addEventListener('click', function (e) {
    Swal.fire({
      title: "Logout?",
      text: "Are you sure you want to logout?",
      icon: "question",
      showCancelButton: true,
      confirmButtonColor: "#3085d6",
      cancelButtonColor: "#d33",
      confirmButtonText: "Logout"
    }).then((result) => {
      if (result.isConfirmed) {
        // Redirect to logout route
        window.location.href = "<?= base_url('admin/login') ?>";
      }
    });
  });
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.3/font/bootstrap-icons.css">
<script>
    const base_url = "<?= base_url() ?>";
</script>
<script src="<?= base_url('/assets/js/event.js') ?>"></script>
<script src="<?= base_url('/assets/js/gallery.js') ?>"></script>
<script>
  document.querySelector('#galleryTable').addEventListener('click', function(e) {
      if (e.target.closest('.edit-gallery-btn')) {
          const button = e.target.closest('.edit-gallery-btn');

          // Extract data from button
          document.getElementById('editGalleryId').value = button.getAttribute('data-id');
          document.getElementById('editName').value = button.getAttribute('data-name');
          document.getElementById('editCategory').value = button.getAttribute('data-category');
          document.getElementById('editDate').value = button.getAttribute('data-date');
      }
  });

  document.getElementById('editGalleryForm').addEventListener('submit', function(e) {
    e.preventDefault();

    const form = e.target;
    const formData = new FormData(form);

    fetch("<?= base_url('/admin/updateGallery') ?>", {
        method: 'POST',
        body: formData,
    })
    .then(response => response.json())
    .then(result => {
        if (result.status === 'success') {
            Swal.fire({
                title: 'Success',
                text: result.message,
                icon: 'success',
                showConfirmButton: false,
                timer: 1000
            });

            // Close modal
            const modal = bootstrap.Modal.getInstance(document.getElementById('editModal'));
            modal.hide();

            // Reload DataTable
            $('#galleryTable').DataTable().ajax.reload();
        } else {
            Swal.fire({
                title: 'Error',
                text: result.message,
                icon: 'error'
            });
        }
    })
    .catch(error => {
        Swal.fire({
            title: 'Error',
            text: 'Something went wrong while updating the gallery.',
            icon: 'error'
        });
        console.error('Update error:', error);
    });
  });

</script>
<script src="<?= base_url('/assets/js/member.js') ?>"></script>
<script src="<?= base_url('/assets/js/user.js') ?>"></script>
</body>
</html>