<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="csrf-token" content="<?= csrf_hash() ?>">

  <base href="/">

  <meta name="description" content="SRG Foundations collectively making a small effort to preserve this invaluable heritage of indigenous cattle, a symbol of Sanatan Dharma, and a national treasure of undivided India.">
  <meta name="author" content="Wind Hans Technologies">
  <link rel="icon" type="image/png" sizes="40x40" href="<?= base_url('/upload/admin/favicon.png') ?>">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://kit.fontawesome.com/c20abdb703.js" crossorigin="anonymous"></script>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Jost:wght@500;600&amp;family=Roboto&amp;display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700&amp;display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <link href="/styles.css" rel="stylesheet" />
  <link href="https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.snow.css" rel="stylesheet" />
  <script src="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.9.0/highlight.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.js"></script>
  <link
    rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.9.0/styles/atom-one-dark.min.css"
  />
  <script src="https://cdn.jsdelivr.net/npm/katex@0.16.9/dist/katex.min.js"></script>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/katex@0.16.9/dist/katex.min.css" />
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

  <link rel="stylesheet" href="<?= base_url('/assets/admin.css') ?>">
  <link rel="stylesheet" href="<?= base_url('/assets/profile.css') ?>">

  <title>Shree Rajlaxmi Gaushala</title>

  <style>
    #carouselTable thead th.sorting:after,
    #carouselTable thead th.sorting_asc:after,
    #carouselTable thead th.sorting_desc:after {
      display: none !important;
    }
    #carouselTable thead th.sorting::before,
    #carouselTable thead th.sorting_asc::before,
    #carouselTable thead th.sorting_desc::before {
      display: none !important;
    }

    #blogTable thead th.sorting:after,
    #blogTable thead th.sorting_asc:after,
    #blogTable thead th.sorting_desc:after {
      display: none !important;
    }
    #blogTable thead th.sorting::before,
    #blogTable thead th.sorting_asc::before,
    #blogTable thead th.sorting_desc::before {
      display: none !important;
    }

    #eventTable thead th.sorting:after,
    #eventTable thead th.sorting_asc:after,
    #eventTable thead th.sorting_desc:after {
      display: none !important;
    }
    #eventTable thead th.sorting::before,
    #eventTable thead th.sorting_asc::before,
    #eventTable thead th.sorting_desc::before {
      display: none !important;
    }

    #galleryTable thead th.sorting:after,
    #galleryTable thead th.sorting_asc:after,
    #galleryTable thead th.sorting_desc:after {
      display: none !important;
    }
    #galleryTable thead th.sorting::before,
    #galleryTable thead th.sorting_asc::before,
    #galleryTable thead th.sorting_desc::before {
      display: none !important;
    }

    #memberTable thead th.sorting:after,
    #memberTable thead th.sorting_asc:after,
    #memberTable thead th.sorting_desc:after {
      display: none !important;
    }
    #memberTable thead th.sorting::before,
    #memberTable thead th.sorting_asc::before,
    #memberTable thead th.sorting_desc::before {
      display: none !important;
    }

    #userTable thead th.sorting:after,
    #userTable thead th.sorting_asc:after,
    #userTable thead th.sorting_desc:after {
      display: none !important;
    }
    #userTable thead th.sorting::before,
    #userTable thead th.sorting_asc::before,
    #userTable thead th.sorting_desc::before {
      display: none !important;
    }
  </style>


</head>
<body>

<div class="app">
  <div id="spinner" style="background-color: rgba(0, 0, 0, 0.6);" class=" w-100 vh-100 position-fixed translate-middle top-50 start-50  d-flex align-items-center justify-content-center">
    <div class="spinner-grow text-primary" role="status"></div>
  </div>

  <div class="admin-wrapper">
    <div id="spinner" style="background-color: rgba(0, 0, 0, 0.6);" class=" w-100 vh-100 position-fixed translate-middle top-50 start-50  d-flex align-items-center justify-content-center">
      <div class="spinner-grow text-primary" role="status"></div>
    </div>

    <header id="header" class="header fixed-top d-flex align-items-center">
      <div class="d-flex align-items-center justify-content-between">
        <a href="admin/dashboard" class="logo d-flex align-items-center">
          <img src="<?= base_url('/uploads/SRGLogo.jpg') ?>" alt="">
          <span class="d-none d-lg-block">S.R.Gaushala</span>
        </a>
        <i class="bi bi-list toggle-sidebar-btn"></i>
      </div>

      <nav class="header-nav ms-auto">
        <ul class="d-flex align-items-center">
          <li class="nav-item dropdown pe-3">
            <a class="nav-link nav-profile d-flex align-items-center pe-0" href="#" data-bs-toggle="dropdown">
              <span class="d-none d-md-block dropdown-toggle ps-2">Admin</span>
            </a>
            <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
              <li class="dropdown-header"><h6>Admin</h6></li>
              <li><hr class="dropdown-divider"></li>
              <li>  
                <a class="dropdown-item d-flex align-items-center" href="<?= base_url('/admin/profile') ?>">
                  <i class="bi bi-person"></i>
                  <span>My Profile</span>
                </a>
              </li>
              <li><hr class="dropdown-divider"></li>
              <li>
                <button id="logoutBtn" class="dropdown-item d-flex align-items-center">
                  <i class="bi bi-box-arrow-right"></i>
                  <span>Sign Out</span>
                </button>
              </li>
            </ul>
          </li>
        </ul>
      </nav>
    </header>

    <aside id="sidebar" class="sidebar">
      <ul class="sidebar-nav" id="sidebar-nav">
        <li class="nav-item">
          <a href="<?= base_url('/admin/dashboard') ?>" class="nav-link">
            <i class="bi bi-grid"></i>
            <span>Dashboard</span>
          </a>
        </li>
        <li class="nav-item">
          <a href="<?= base_url('/admin/carousel') ?>" class="nav-link active" aria-current="page">
            <i class="bi bi-table"></i>
            <span>Carousels</span>
          </a>
        </li>
        <li class="nav-item">
          <a href="<?= base_url('/admin/blog/blog-post') ?>" class="nav-link">
            <i class="bi bi-table"></i>
            <span>Blog-Posts</span>
          </a>
        </li>
        <li class="nav-item">
          <a href="<?= base_url('/admin/event/manage-event') ?>" class="nav-link">
            <i class="bi bi-table"></i>
              <span>Events</span>
          </a>
        </li>
        <li class="nav-item">
            <a href="<?= base_url('/admin/manage-members') ?>" class="nav-link">
              <i class="bi bi-table"></i>
              <span>Members</span>
            </a>
        </li>
        <li class="nav-item">
            <a href="<?= base_url('/admin/manage-users') ?>" class="nav-link">
              <i class="bi bi-table"></i>
              <span>Users</span>
            </a>
        </li>
        <li class="nav-item">
            <a href="<?= base_url('/admin/manage-gallery') ?>" class="nav-link">
              <i class="bi bi-table"></i>
              <span>Gallery</span>
            </a>
        </li>
      </ul>
    </aside>
  
  <main id="main" class="main">

  
