<?= $this->include('templates/header') ?>

<div class="container-fluid bg-breadcrumb">
    <div class="container text-center py-5" style="max-width: 900px;">
        <h3 class="text-white display-3 mb-4">Blogs</h3>
        <p class="fs-5 text-white mb-4">“May Mother Cow be welcomed into our homes"<br>May every person give a place to Mother Cow in their life, family, and heart</p>
        <ol class="breadcrumb justify-content-center mb-0">
            <li class="breadcrumb-item">
                <a href="<?= base_url('/') ?>">Home</a>
            </li>
            <li class="breadcrumb-item">
                <a>Pages</a>
            </li>
            <li class="breadcrumb-item active text-white">Blogs</li>
        </ol>
    </div>
</div>

<div class="container-fluid blog py-5 bg-light">
  <div class="container py-5">
    <div class="text-center mx-auto pb-5" style="max-width: 800px;">
      <h5 class="text-uppercase text-primary">Latest Blogs</h5>
      <h1 class="mb-0">
        See the Latest Blog Posts of Gaushala
      </h1>
    </div>
    <div class="row g-4">
      <?php if(!empty($posts)): ?>
        <?php foreach($posts as $post): ?>
        <div class="col-lg-6 col-xl-3">
          <div class="blog-item" style="display: flex; flex-direction: column; height: 100%;">
            <div class="blog-img">
              <img src="<?= base_url('/uploads/Blog/'). esc($post['image']) ?> ?>" class="img-fluid w-100" alt="<?= esc($post['title']) ?>" style="aspect-ratio:4/3">
              <div class="blog-info">
                <span><i class="fa fa-clock"></i><?= date('d M, Y', strtotime($post['date'])) ?></span>
              </div>
              <div class="search-icon">
                <a href="<?= base_url('/uploads/Blog/'). esc($post['image']) ?> ?>" title="<?= esc($post['title']) ?>" data-lightbox="<?= esc($post['title']) ?>" class="my-auto">
                  <i class="fas fa-search-plus btn-primary text-white p-3"></i>
                </a>
              </div>
            </div>
            <div class="text-dark border p-4 " style="flex-grow: 1; display: flex; flex-direction: column; justify-content: space-between;">
              <h4 class="mb-4"><?= esc($post['title']) ?></h4>
              <p class="mb-4 text-wrap">
                <p><?= esc(substr(strip_tags($post['description']), 0, 100)) ?>...</p>
              </p>
              <a class="btn-hover-bg btn btn-primary text-white py-2 px-4" href="<?= base_url('/main/detail/'. $post['sno'])?>">Read More</a>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
      <?php else: ?>
        <p>No blogs available right now.</p>
      <?php endif; ?>
    </div>
  </div>
</div>

<?= $this->include('templates/footer') ?>
