<?= $this->include('templates/header') ?>

<div class="container-fluid bg-breadcrumb">
    <div class="container text-center py-5" style="max-width: 900px;">
      <h3 class="text-white display-3 mb-4">Contact Us</h3>
      <p class="fs-5 text-white mb-4">“May Mother Cow be welcomed into our homes"<br>May every person give a place to Mother Cow in their life, family, and heart</p>
      <ol class="breadcrumb justify-content-center mb-0">
        <li class="breadcrumb-item"><a href="<?= base_url('/') ?>">Home</a></li>
        <li class="breadcrumb-item"><a>Pages</a></li>
        <li class="breadcrumb-item active text-white">Contact</li>
      </ol>
    </div>
</div>

<div class="container-fluid bg-light py-5">
    <div class="container py-5">
        <div class="contact p-5">
            <div class="row g-4">
                <div class="col-xl-5">
                    <form action="<?= base_url('/main/storeUser') ?>" method="post" enctype="multipart/form-data">
                        <h1 class="mb-4">Get in touch</h1>
                        <p>For questions, concerns, or feedback, please reach out to us:</p>
                        <div class="row gx-4 gy-3">
                            <div class="col-xl-6">
                                <input placeholder="Your Full Name" name="name" 
                                    value="<?= old('name') ?>" 
                                    class="form-control bg-white border-0 py-3 px-4 <?= isset($validation) && $validation->hasError('name') ? 'invalid' : '' ?>"
                                >
                                <?php if (isset($validation) && $validation->hasError('name')): ?>
                                    <div class="text-danger"><?= $validation->getError('name') ?></div>
                                <?php endif; ?>
                            </div>
                            <div class="col-xl-6">
                                <input placeholder="Your Email Id" name="email"
                                    value="<?= old('email') ?>"
                                    class="form-control bg-white border-0 py-3 px-4 <?= isset($validation) && $validation->hasError('email') ? 'invalid' : '' ?>"
                                >
                                <?php if (isset($validation) && $validation->hasError('email')): ?>
                                    <div class="text-danger"><?= $validation->getError('email') ?></div>
                                <?php endif; ?>
                            </div>
                            <div class="col-12">
                                <input placeholder="Your Phone Number" name="phone"
                                    value="<?= old('phone') ?>"
                                    class="form-control bg-white border-0 py-3 px-4 <?= isset($validation) && $validation->hasError('phone') ? 'invalid' : '' ?>"
                                >
                                <?php if (isset($validation) && $validation->hasError('phone')): ?>
                                    <div class="text-danger"><?= $validation->getError('phone') ?></div>
                                <?php endif; ?>
                            </div>
                            <div class="col-12">
                                <input placeholder="Subject" name="subject"
                                    value="<?= old('subject') ?>"
                                    class="form-control bg-white border-0 py-3 px-4 <?= isset($validation) && $validation->hasError('subject') ? 'invalid' : '' ?>"
                                >
                                <?php if (isset($validation) && $validation->hasError('subject')): ?>
                                    <div class="text-danger"><?= $validation->getError('subject') ?></div>
                                <?php endif; ?>
                            </div>
                            <div class="col-12">
                                <textarea placeholder="Message" name="message" class="form-control bg-white border-0 py-3 px-4 <?= isset($validation) && $validation->hasError('message') ? 'invalid' : '' ?>"><?= old('message') ?></textarea>
                                <?php if (isset($validation) && $validation->hasError('message')): ?>
                                    <div class="text-danger"><?= $validation->getError('message') ?></div>
                                <?php endif; ?>
                            </div>
                            <div class="col-12">
                                <button class="btn-hover-bg btn btn-primary w-100 py-3 px-5" type="submit">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="col-xl-7">
                    <div>
                        <div class="row g-4">
                            <div class="col-lg-12">
                                <div class="bg-white p-4">
                                    <i class="fas fa-map-marker-alt fa-2x text-primary mb-2"></i>
                                    <h4>Address</h4>
                                    <p class="mb-0">Rajlaxmi Gaushala Sanstha, Tapovan Link Rd, Vaishnavi Park, Nashik, Maharashtra 422013.</p>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div style="height:100%" class="bg-white p-4">
                                    <i class="fas fa-envelope fa-2x text-primary mb-2"></i>
                                    <h4>Mail Us</h4>
                                    <p class="mb-0">
                                        <a href="mailto:shrirajlaxmifoundation9@gmail.com" style="color:#757575;word-wrap:break-word;width:100px">shrirajlaxmifoundation9@gmail.com</a>
                                    </p>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="bg-white p-4">
                                    <i class="fa fa-phone-alt fa-2x text-primary mb-2"></i>
                                    <h4>Mobile</h4>
                                    <p class="mb-0">
                                        <a href="tel:+918007777486" style="color:#757575">+91 8007-777-486</a>
                                    </p>
                                    <p class="mb-0">
                                        <a href="tel:+919359291816" style="color:#757575">+91 9359-291-816</a>
                                    </p>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <iframe style="border:0;width:100%;height:500px" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d6950.7507284205085!2d73.81709330121424!3d20.004885490469245!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3bddebcfa2eeeeb9%3A0xb358222a1a3c39d7!2sShrirajlaxmi%20Goshala!5e0!3m2!1sen!2sin!4v1715505693057!5m2!1sen!2sin"></iframe>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->include('templates/footer') ?>