<?= $this->include('templates/header') ?>

<div class="container-fluid bg-breadcrumb">
    <div class="container text-center py-5" style="max-width: 900px;">
        <h3 class="text-white display-3 mb-4">Events</h3>
        <p class="fs-5 text-white mb-4">“May Mother Cow be welcomed into our homes"<br>May every person give a place to Mother Cow in their life, family, and heart</p>
        <ol class="breadcrumb justify-content-center mb-0">
            <li class="breadcrumb-item">
                <a href="<?= base_url('/') ?>">Home</a>
            </li>
            <li class="breadcrumb-item">
                <a>Pages</a>
            </li>
            <li class="breadcrumb-item active text-white">Events</li>
        </ol>
    </div>
</div>

<div class="container-fluid event py-5">
  <div class="container py-5">
    <div class="text-center mx-auto mb-5" style="max-width: 800px;">
      <h5 class="text-uppercase text-primary">Upcoming Events</h5>
      <h1 class="mb-0">See the Latest Events in Gaushala</h1>
    </div>
    <div class="event-carousel row g-4 ">
      <?php if(!empty($events)): ?>
        <?php foreach($events as $event): ?>
          <?php
            $cleanTitle = strip_tags($event['title']);
            $shortTitle = strlen($cleanTitle) > 25 ? substr($cleanTitle, 0, 25) . '...' : $cleanTitle;
          ?>
          <?php
            $cleanAddress = strip_tags($event['address']);
            $shortAddress = strlen($cleanAddress) > 25 ? substr($cleanAddress, 0, 25) . '...' : $cleanAddress;
          ?>
      <!-- <div class="col-12 col-md-6 col-lg-4 d-flex justify-content-center"> -->
        <div class="event-item col-4" style="width: 420px;">
          <img src="<?= base_url('uploads/Event/').esc($event['image']) ?>" class="img-fluid" style="aspect-ratio: 4/3;object-fit:cover;width:400px" alt="<?= esc($event['title']) ?>">
          <div class="event-content p-4">
            <div class="d-flex justify-content-between mb-4">
              <span style="font-size:15px" class="text-body">
                <i class="fas fa-map-marker-alt me-2"></i><?= esc($shortAddress) ?>
                
              </span>
              <span style="font-size:15px" class="text-body">
                <i class="fas fa-calendar-alt me-2"></i><?= date('d M, Y', strtotime($event['date'])) ?>
              </span>
            </div>
            <h4 class="mb-4 text-wrap"><?= esc($shortTitle) ?></h4>
            <p class="mb-4"><?= esc($event['introduction']) ?></p>
            <a class="btn-hover-bg btn btn-primary text-white py-2 px-4" href="<?= base_url('/main/eventDetail/'). $event['sno'] ?>">Read More</a>
          </div>
        </div>
      <!-- </div> -->
      <?php endforeach; ?>
      <?php else: ?>
        <p>No events available right now.</p>
      <?php endif; ?>
    </div>
  </div>
</div>

<?= $this->include('templates/footer') ?>