<?= $this->include('templates/header') ?>

<div class="container-fluid bg-breadcrumb">
    <div class="container text-center py-5" style="max-width: 900px;">
      <h3 class="text-white display-3 mb-4">Gallery</h3>
      <p class="fs-5 text-white mb-4">“May Mother Cow be welcomed into our homes"<br>May every person give a place to Mother Cow in their life, family, and heart</p>
      <ol class="breadcrumb justify-content-center mb-0">
        <li class="breadcrumb-item"><a href="<?= base_url('/') ?>">Home</a></li>
        <li class="breadcrumb-item"><a>Pages</a></li>
        <li class="breadcrumb-item active text-white">Gallery</li>
      </ol>
    </div>
</div>

<div class="container-fluid gallery py-5 px-0">
  <div class="text-center mx-auto pb-5" style="max-width: 800px;">
    <h5 class="text-uppercase text-primary">Our work</h5>
    <h1 class="mb-4">Home for Indian Cows</h1>
    <p class="mb-0">Cows are let free during the day and given the best possible environment. Healthy fodder is given to each and every cow with lots of love and affection. A big pond is made for them to bathe. Regular medical checkups are done and other facilities are provided for them.</p>
  </div>
  <div class="row g-0">
     <?php if(!empty($galleries)): ?>
        <?php foreach($galleries as $gallery): ?>
        <div class="col-lg-4">
          <div class="gallery-item">
              <?php
                $images = json_decode($gallery['image'], true);
              ?>
            <img src="<?= base_url('/uploads/gallery/'). $images[0] ?>" class="img-fluid w-100" style="aspect-ratio:4/3" alt="<?= esc($gallery['name']) ?>">
            <div class="search-icon">
              <a href="<?= base_url('/uploads/gallery/'). $images[0] ?>" title="<?= esc($gallery['name']) ?>" data-lightbox="gallery-<?= $gallery['sno'] ?>" class="my-auto">
                <i class="fas fa-search-plus btn-hover-color bg-white text-primary p-3"></i>
              </a>
            </div>
             <!-- Additional hidden links for Lightbox gallery -->
            <?php foreach (array_slice($images, 1) as $img): ?>
              <a href="<?= base_url('uploads/gallery/' . $img) ?>" data-lightbox="gallery-<?= $gallery['sno'] ?>" data-title="<?= esc($gallery['name']) ?>" class="d-none"></a>
            <?php endforeach; ?>

            <div class="gallery-content">
              <div class="gallery-inner pb-5">
                <a class="h4 text-white"><?= esc($gallery['name']) ?></a>
                <a class="text-white">
                  <p class="mb-0"><?= esc($gallery['category']) ?></p>
                </a>
              </div>
            </div>
            
          </div>
        </div>
        <?php endforeach; ?>
      <?php else: ?>
        <p>No gallery available right now.</p>
      <?php endif; ?>
  </div>
</div>

<?= $this->include('templates/footer') ?>
