<?= $this->include('templates/header') ?>

<!-- Carousel Image -->
<div class="container-fluid carousel-header vh-100 px-0">
  <div id="carouselId" class="carousel slide" data-bs-ride="carousel">
    
    <!-- Carousel Indicators -->
    <ol class="carousel-indicators">
      <?php foreach ($slides as $index => $slide): ?>
        <button data-bs-target="#carouselId" data-bs-slide-to="<?= $index ?>" class="<?= $index === 0 ? 'active' : '' ?>" aria-current="<?= $index === 0 ? 'true' : 'false' ?>"></button>
      <?php endforeach; ?>
    </ol>

    <!-- Carousel Items -->
    <div class="carousel-inner" role="listbox">
      <?php foreach ($slides as $index => $slide): ?>
        <div class="carousel-item <?= $index === 0 ? 'active' : '' ?>">
          <img src="<?= base_url('/uploads/Carousel/' . $slide['image']) ?>" class="img-fluid" alt="<?= esc($slide['title']) ?>">
          <div class="carousel-caption">
            <div class="p-3" style="max-width: 900px;">
              <h4 class="text-white text-uppercase fw-bold mb-4" style="letter-spacing: 3px;"><?= esc($slide['sub-title']) ?></h4>
              <h1 class="display-1 text-capitalize text-white mb-4"><?= esc($slide['title']) ?></h1>
              <p class="mb-5 fs-5"><?= esc($slide['description']) ?></p>
              <div class="d-flex align-items-center justify-content-center">
                <a class="btn-hover-bg btn btn-primary text-white py-3 px-5" href="<?= base_url('/main/members') ?>">Join With Us</a>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>

    <!-- Controls -->
    <button class="carousel-control-prev" type="button" data-bs-target="#carouselId" data-bs-slide="prev">
      <span class="carousel-control-prev-icon" aria-hidden="true"></span>
      <span class="visually-hidden">Previous</span>
    </button>
    <button class="carousel-control-next" type="button" data-bs-target="#carouselId" data-bs-slide="next">
      <span class="carousel-control-next-icon" aria-hidden="true"></span>
      <span class="visually-hidden">Next</span>
    </button>
  </div>
</div>

<!-- About -->
<div class="container-fluid about py-5">
  <div class="container py-5">
    <div class="row g-5 align-items-center">
      <div class="col-xl-5">
        <div class="h-100">
          <img src="<?= base_url('/uploads/SRGLogo.jpg') ?>" class="img-fluid" style="height:auto;width:530px" alt="Image">
        </div>
      </div>
      <div class="col-xl-7">
        <h5 class="text-uppercase text-primary">About Us</h5>
        <h1 class="mb-4">A Place of Care and Conservation for Sacred Cows</h1>
        <div class="tab-class bg-secondary p-4">
          <ul class="nav d-flex mb-2">
          <li class="nav-item mb-3">
            <a class="d-flex py-2 text-center bg-white active" data-bs-toggle="pill" href="#tab-1">
              <span class="text-dark" style="width: 150px;">About</span>
            </a>
          </li>
          <li class="nav-item mb-3">
            <a class="d-flex py-2 mx-3 text-center bg-white" data-bs-toggle="pill" href="#tab-2">
              <span class="text-dark" style="width: 150px;">Mission</span>
            </a>
          </li>
          <li class="nav-item mb-3">
            <a class="d-flex py-2 text-center bg-white" data-bs-toggle="pill" href="#tab-3">
              <span class="text-dark" style="width: 150px;">Vision</span>
            </a>
          </li>
        </ul>
        <div class="tab-content">
          <div id="tab-1" class="tab-pane fade show p-0 active">
            <div class="row">
              <div class="col-12">
                <div class="d-flex">
                  <div class="text-start my-auto">
                    <h5 class="text-uppercase mb-3">About Us</h5>
                    <p class="mb-4 aboutp">
                      Dear esteemed members of the Shrirajlakshmi family,<br><br>
                      We are pleased to inform you that the NGO registration for our gaushala, along with the 12A and 80G certificates, has been completed. In recognition of the service activities we have been performing, the Maharashtra Government's Gau Seva Commission has officially registered the 'Shrirajlakshmi Gaushala' operated by the Shrirajlakshmi Foundation Nashik, under the provisions and conditions of Section 12 of the Maharashtra Gauseva Commission Act, 2023.
                      This journey, which began 22 years ago as a solo effort, has transformed into an organization with the support and blessings of all of you. We have grown from 7 members to 600 members, and from 7 cows to 125 cows. The gaushala has provided refuge to stray cattle through 17 actions by the Nashik City Police Administration, 9 actions by the Nashik Municipal Corporation, and through donations of cows.<br><br>
                      We are collectively making a small effort to preserve this invaluable heritage of indigenous cattle, a symbol of Sanatan Dharma, and a national treasure of undivided India.
                    </p>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div id="tab-2" class="tab-pane fade show p-0">
            <div class="row">
              <div class="col-12">
                <div class="d-flex">
                  <div class="text-start my-auto">
                    <h5 class="text-uppercase mb-3">Mission</h5>
                    <p class="mb-4 aboutp">
                        "Enriching the indigenous cattle in the gaushala, and instead of keeping them confined, releasing this invaluable heritage back into nature for free movement as given by nature thats our main mission"
                    </p>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div id="tab-3" class="tab-pane fade show p-0">
            <div class="row">
              <div class="col-12">
                <div class="d-flex">
                  <div class="text-start my-auto">
                    <h5 class="text-uppercase mb-3">Vision</h5>
                    <p class="mb-4 aboutp">
                      "Making efforts to transport the well-nourished cattle from the gaushala to grazing lands and farmers, thereby freeing Mother Earth from poison, and striving to produce the best food for future human life"
                    </p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
</div>

<!-- Services -->
<div class="container-fluid service py-5 bg-light">
  <div class="container py-5">
    <div class="text-center mx-auto pb-5" style="max-width: 800px;">
      <h5 class="text-uppercase text-primary">What we do</h5>
      <h1 class="mb-0">What we do to Protection of Cows, Calves and their Health</h1>
    </div>
    <div class="row g-4">
      <div class="col-md-6 col-lg-6 col-xl-3">
        <div class="service-item">
          <img src="<?= base_url('/uploads/services/protection.jpg') ?>" class="img-fluid w-100" style="aspect-ratio:4/3" alt="Image">
          <div class="service-link">
            <a class="h4 mb-0">Protection of Cows</a>
          </div>
        </div>
          <p class="my-4">
              As on date 21,000+ stray/ destitute Desi Indian Cows / bulls and her progenies are being sheltered in our Gaurakshashala which are brought through various channels such as Police, Government, NGOs, Farmers etc. We give these gauvansh a second life.
          </p>
      </div>
      <div class="col-md-6 col-lg-6 col-xl-3">
          <div class="service-item">
            <img src="<?= base_url('/uploads/services/shelter.jpg') ?>" class="img-fluid w-100" style="aspect-ratio:4/3" alt="Image">
            <div class="service-link">
              <a class="h4 mb-0">Shelter</a>
            </div>
          </div>
          <p class="my-4">
              We have very big adequate facility to provide good shelters to these rescued gauvansh. We continue building cow sheds as the number of cows being protected are increasing day by day.
          </p>
      </div>
      <div class="col-md-6 col-lg-6 col-xl-3">
          <div class="service-item">
            <img src="<?= base_url('/uploads/services/dryfodder.jpg') ?>" class="img-fluid w-100" style="aspect-ratio:4/3" alt="Image">
            <div class="service-link">
              <a class="h4 mb-0">Dry Fodder Storage</a>
            </div>
          </div>
          <p class="my-4">
            We have huge dry fodder (Husk) storage for storing approx. 40 lakh kg of dry husk. We have to mandatorily store as it is the main ingredient of cow food. We require at least 90 lakh kg of dry fodder (Husk) annually.
          </p>
      </div>
      <div class="col-md-6 col-lg-6 col-xl-3">
          <div class="service-item">
            <img src="<?= base_url('/uploads/services/medical.jpg') ?>" class="img-fluid w-100" style="aspect-ratio:4/3" alt="Image">
            <div class="service-link">
              <a class="h4 mb-0">Medical Facility</a>
            </div>
          </div>
          <p class="my-4">
            We have doctors available 24/7, providing comprehensive in-house medical facilities. We maintain ample stocks of necessary medicine and vaccinations.
          </p>
      </div>
      <div class="col-12">
          <div class="d-flex align-items-center justify-content-center">
            <a class="btn-hover-bg btn btn-primary text-white py-2 px-4" href="<?= base_url('/main/services') ?>">Read More</a>
          </div>
      </div>
    </div>
  </div>
</div>

<!-- Events -->
<div class="container-fluid event py-5">
  <div class="container py-5">
    <div class="text-center mx-auto mb-5" style="max-width: 800px;">
      <h5 class="text-uppercase text-primary">Upcoming Events</h5>
      <h1 class="mb-0">See the Latest Events in Gaushala</h1>
    </div>
    <div class="event-carousel row g-3">
      <?php if(!empty($events)): ?>
        <?php foreach(array_slice($events, 0, 3) as $event):  ?>
          <?php
            $cleanTitle = strip_tags($event['title']);
            $shortTitle = strlen($cleanTitle) > 25 ? substr($cleanTitle, 0, 25) . '...' : $cleanTitle;
          ?>
          <?php
            $cleanAddress = strip_tags($event['address']);
            $shortAddress = strlen($cleanAddress) > 25 ? substr($cleanAddress, 0, 25) . '...' : $cleanAddress;
          ?>
          <div class="col-12 col-md-6 col-lg-4 d-flex justify-content-center">
            <div class="event-item" style="width: 450px;">
              <img src="<?= base_url('uploads/Event/').esc($event['image']) ?>" class="img-fluid" style="aspect-ratio: 4/3;object-fit:cover;width:100%" alt="<?= esc($event['title']) ?>">
              <div class="event-content p-4">
                <div class="d-flex justify-content-between mb-4">
                  <span style="font-size:15px" class="text-body">
                    <i class="fas fa-map-marker-alt me-2"></i><?= esc( $shortAddress)?>
                  </span>
                  <span style="font-size:15px" class="text-body">
                    <i class="fas fa-calendar-alt me-2"></i><?= date('d M, Y', strtotime($event['date'])) ?>
                  </span>
                </div>
                <h4 class="mb-4 text-wrap"><?= esc($shortTitle) ?></h4>
                <p class="mb-4"><?= esc($event['introduction']) ?></p>
                <a class="btn-hover-bg btn btn-primary text-white py-2 px-4" href="<?= base_url('/main/eventDetail/'). $event['sno'] ?>">Read More</a>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
        <?php else: ?>
        <p>No events available right now.</p>
      <?php endif; ?>

    </div>
  </div>
</div>

<!-- Blog -->
<div class="container-fluid blog py-5 bg-light">
  <div class="container py-5">
    <div class="text-center mx-auto pb-5" style="max-width: 800px;">
      <h5 class="text-uppercase text-primary">Latest Blogs</h5>
      <h1 class="mb-0">
        See the Latest Blog Posts of Gaushala
      </h1>
    </div>
    <div class="row g-4">
      <?php if(!empty($posts)): ?>
        <?php foreach(array_slice($posts, 0, 4) as $post): ?>
        <div class="col-lg-6 col-xl-3">
          <div class="blog-item" style="display: flex; flex-direction: column; height: 100%;">
            <div class="blog-img">
              <img src="<?= base_url('/uploads/Blog/') . esc($post['image']) ?>" class="img-fluid w-100" alt="<?= esc($post['title']) ?>" style="aspect-ratio:4/3">
              <div class="blog-info">
                <span><i class="fa fa-clock"></i> 19 Nov, 2024</span>
              </div>
              <div class="search-icon">
                <a href="<?= base_url('/uploads/Blog/'). esc($post['image'])  ?>" title="<?= esc($post['title']) ?>" data-lightbox="<?= esc($post['title']) ?>" class="my-auto">
                  <i class="fas fa-search-plus btn-primary text-white p-3"></i>
                </a>
              </div>
            </div>
            <div class="text-dark border p-4 " style="flex-grow: 1; display: flex; flex-direction: column; justify-content: space-between;">
              <h4 class="mb-4"><?= esc($post['title']) ?></h4>
              <p class="mb-4 text-wrap">
                <p><?= esc(substr(strip_tags($post['description']), 0, 100)) ?>...</p>
              </p>
              <a class="btn-hover-bg btn btn-primary text-white py-2 px-4" href="<?= base_url('/main/detail/'. $post['sno'])?>">Read More</a>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
      <?php else: ?>
        <p>No blogs available right now.</p>
      <?php endif; ?>
    </div>
  </div>
</div>

<!-- Gallery -->
<div class="container-fluid gallery py-5 px-0">
  <div class="text-center mx-auto pb-5" style="max-width: 800px;">
    <h5 class="text-uppercase text-primary">Our work</h5>
    <h1 class="mb-4">Home for Indian Cows</h1>
    <p class="mb-0">Cows are let free during the day and given the best possible environment. Healthy fodder is given to each and every cow with lots of love and affection. A big pond is made for them to bathe. Regular medical checkups are done and other facilities are provided for them.</p>
  </div>
  <div class="row g-0">
     <?php if(!empty($galleries)): ?>
        <?php foreach(array_slice($galleries, 0, 6) as $gallery): ?>
        <div class="col-lg-4">
          <div class="gallery-item">
              <?php
                $images = json_decode($gallery['image'], true);
              ?>
            <img src="<?= base_url('/uploads/gallery/'). $images[0] ?>" class="img-fluid w-100" style="aspect-ratio:4/3" alt="<?= esc($gallery['name']) ?>">
            <div class="search-icon">
              <a href="<?= base_url('/uploads/gallery/'). $images[0] ?>" title="<?= esc($gallery['name']) ?>" data-lightbox="gallery-<?= $gallery['sno'] ?>" class="my-auto">
                <i class="fas fa-search-plus btn-hover-color bg-white text-primary p-3"></i>
              </a>
            </div>
             <!-- Additional hidden links for Lightbox gallery -->
            <?php foreach (array_slice($images, 1) as $img): ?>
              <a href="<?= base_url('uploads/gallery/' . $img) ?>" data-lightbox="gallery-<?= $gallery['sno'] ?>" data-title="<?= esc($gallery['name']) ?>" class="d-none"></a>
            <?php endforeach; ?>

            <div class="gallery-content">
              <div class="gallery-inner pb-5">
                <a class="h4 text-white"><?= esc($gallery['name']) ?></a>
                <a class="text-white">
                  <p class="mb-0"><?= esc($gallery['category']) ?></p>
                </a>
              </div>
            </div>
            
          </div>
        </div>
        <?php endforeach; ?>
      <?php else: ?>
        <p>No gallery available right now.</p>
      <?php endif; ?>
  </div>
</div>

<!--Volunteer  -->
<div class="container-fluid volunteer py-5 mt-5">
  <div class="container py-5">
    <div class="row g-5">
      <div class="col-lg-12">
        <h5 class="text-uppercase text-primary">Become a Member?</h5>
        <h1 class="mb-4">Participate in Cow Feeding, Gopooja, Adopting a Cow and other such Activities</h1>
        <p class="mb-4">
          Participate in member activities, contribute financially, and spread awareness about the importance of cow protection.
        </p>
        <p class="text-dark">
          <i class=" fa fa-check text-primary me-2"></i>To promote Cow Based Economy in surrounding areas.
        </p>
        <p class="text-dark">
          <i class=" fa fa-check text-primary me-2"></i> To protect the environment against degradation.
        </p>
        <p class="text-dark">
          <i class=" fa fa-check text-primary me-2"></i> To perform service of cows by keeping them in the Gaushala and providing conducive environment for proper feeding medical facilities.
        </p>
        <p class="text-dark">
          <i class=" fa fa-check text-primary me-2"></i> To parent other smaller Gaushalas.
        </p>
        <p class="text-dark mb-5">
          <i class=" fa fa-check text-primary me-2"></i> Joining is totally free. We dont need any money from you.
        </p>
        <a class="btn-hover-bg btn btn-primary text-white py-2 px-4" href="<?= base_url('/main/members') ?>">Join With Us</a>
      </div>
    </div>
  </div>
</div>

<?= $this->include('templates/footer') ?>
