//Datatable Carousel

  let currentPage = 1;
  const pageLength = 10;
  let totalPages = 1;

  $(document).ready(function () {
  const table = $('#carouselTable').DataTable({
    processing: true,
    serverSide: true,
    paging: false,
    searching: false,
    info: false,
    ajax: {
      url: "<?= base_url('admin/carousel/list') ?>",
      type: "GET",
      data: function (d) {
        d.search = $('input[name="search"]').val();
        d.status = $('select[name="status"]').val();
        d.searchDate = $('input[name="searchDate"]').val();
        d.page = currentPage;
        d.length = pageLength;
      },
      error: function (xhr) {
        console.error('Ajax error:', xhr.responseText);
      }
    },
    columns: [
      { data: null, render: (data, type, row, meta) => meta.row + 1 + ((currentPage - 1) * pageLength) },
      { data: 'carousel_image', orderable: false, searchable: false, render: function (data) {
          return `<img src="${data}" style="max-width:100px; max-height:100px;">`;
      }},
      { data: 'title' },
      { data: 'subtitle' },
      { data: 'created_at' },
      { data: 'description' },
      { data: 'status', orderable: false, searchable: false },
      { data: 'action', orderable: false, searchable: false }
    ],
    drawCallback: function (settings) {
      $('#spinner').hide();
      updatePaginationUI(settings.json);
    }
  });

    $('#filterForm').on('submit', function (e) {
      e.preventDefault();
      currentPage = 1;
      table.ajax.reload();
    });

    $('select[name="status"], input[name="searchDate"]').on('change', function () {
      currentPage = 1;
      table.ajax.reload();
    });

    $(document).on('click', '.pagination .page-link', function (e) {
      e.preventDefault();
      const target = $(this);
      if (target.parent().hasClass('disabled') || target.parent().hasClass('active')) return;

      if (target.attr('id') === 'prevPage' && currentPage > 1) currentPage--;
      else if (target.attr('id') === 'nextPage' && currentPage < totalPages) currentPage++;
      else {
        const page = parseInt(target.data('page'));
        if (page) currentPage = page;
      }

      table.ajax.reload();
    });
  });

  function updatePaginationUI(json) {
    const paginationUL = $('.pagination');
    paginationUL.empty();

    const totalRecords = json.recordsFiltered || 0;
    totalPages = Math.ceil(totalRecords / pageLength);

    paginationUL.append(`
      <li class="page-item ${currentPage === 1 ? 'disabled' : ''}">
        <a class="page-link" id="prevPage" style="cursor:pointer;">&laquo;</a>
      </li>
    `);

    const maxPagesToShow = 5;
    let startPage = Math.max(1, currentPage - 2);
    let endPage = Math.min(totalPages, startPage + maxPagesToShow - 1);

    if (endPage - startPage < maxPagesToShow - 1) {
      startPage = Math.max(1, endPage - maxPagesToShow + 1);
    }

    for (let i = startPage; i <= endPage; i++) {
      paginationUL.append(`
        <li class="page-item ${i === currentPage ? 'active' : ''}">
          <a class="page-link" data-page="${i}" style="cursor:pointer;">${i}</a>
        </li>
      `);
    }

    paginationUL.append(`
      <li class="page-item ${currentPage === totalPages ? 'disabled' : ''}">
        <a class="page-link" id="nextPage" style="cursor:pointer;">&raquo;</a>
      </li>
    `);
  }

// ADD CAROUSEL
  document.addEventListener('DOMContentLoaded', function () {
    const addForm = document.getElementById('addCarouselForm');
    addForm.addEventListener('submit', function (e) {
      e.preventDefault();

      const formData = new FormData(addForm);

      fetch("<?= base_url('admin/carousel/store') ?>", {
        method: "POST",
        headers: {
          "X-Requested-With": "XMLHttpRequest"  // important!
        },
        body: formData
      })
      .then(res => res.json())
      .then(data => {
        if (data.status === 'success') {
          $('#exampleModal').modal('hide');
          $('#carouselTable').DataTable().ajax.reload(null, false);
          addForm.reset();
        } else {
          alert(data.message || 'Failed to add carousel');
        }
      })
      .catch(err => {
        console.error('Add Error:', err);
        alert('Something went wrong.');
      });
    });
  });

// edit carousel
  document.addEventListener('click', function (e) {
    if (e.target.closest('.btn-edit-carousel')) {
      const button = e.target.closest('.btn-edit-carousel');

      console.log("RAW BUTTON HTML:", button.outerHTML);

      const sno = button.getAttribute('data-id');
      const title = button.getAttribute('data-title');
      const subtitle = button.getAttribute('data-subtitle');
      const description = button.getAttribute('data-description');
      const status = button.getAttribute('data-status');

      console.log("SNO:", sno);
      console.log("TITLE:", title);
      console.log("SUBTITLE:", subtitle);
      console.log("DESCRIPTION:", description);
      console.log("STATUS:", status);

      document.getElementById('edit-sno').value = sno || '';
      document.getElementById('edit-title').value = title || '';
      document.getElementById('edit-sub-title').value = subtitle || '';
      document.getElementById('edit-description').value = description || '';
      document.getElementById('edit-status').checked = (status || '').toLowerCase() === 'publish';

      document.getElementById('editCarouselForm').action = "<?= base_url('admin/carousel/update') ?>";
    }
  });

  // Submit form with Fetch API
  document.getElementById('editCarouselForm').addEventListener('submit', function (e) {
    e.preventDefault();

    const form = e.target;
    const formData = new FormData(form);

    if (typeof quill !== 'undefined') {
      formData.set('description', quill.root.innerHTML);
    }

    console.log("Submitting to:", form.action);
    console.log("FormData:", Object.fromEntries(formData.entries()));

    fetch(form.action, {
      method: 'POST',
      headers: {
        'X-Requested-With': 'XMLHttpRequest'
      },
      body: formData
    })
      .then(res => res.json())
      .then(response => {
        if (response.status === 'success') {
          Swal.fire({
            title: 'Success',
            text: response.message,
            icon: 'success',
            showConfirmButton: false,
            timer: 1500
          }).then(() => {
            location.reload();
          });
        } else {
          Swal.fire({
            title: 'Error',
            text: response.message || 'Something went wrong.',
            icon: 'error',
            showConfirmButton: false,
            timer: 1500
          });
        }
      })
      .catch(error => {
        console.error("Submission Error:", error);
        Swal.fire({
          title: 'Error',
          text: 'An unexpected error occurred.',
          icon: 'error',
          showConfirmButton: false,
          timer: 1500
        });
      });
  });

// delete carousel

  document.addEventListener('DOMContentLoaded', function () {
    const deleteButtons = document.querySelectorAll('.btn-delete-blog');
    const deleteTitle = document.getElementById('delete-blog-title');
    const deleteId = document.getElementById('delete-blog-id');
    const confirmDeleteBtn = document.getElementById('confirm-delete-btn');

    deleteButtons.forEach(btn => {
          btn.addEventListener('click', function () {
              const id = this.getAttribute('data-id');
              const title = this.getAttribute('data-title');
              deleteTitle.textContent = title;
              deleteId.value = id;
          });
    });

    confirmDeleteBtn.addEventListener('click', function () {
      const id = deleteId.value;
      window.location.href = `<?= base_url('admin/blog/deleteBlog') ?>/${id}`;
    });
  });
