let eventCurrentPage = 1;
const eventPageLength = 10;
let eventTotalPages = 1;

$(document).ready(function () {
  const eventTable = $('#eventTable').DataTable({
    processing: true,
    serverSide: true,
    paging: false,
    searching: false,
    info: false,
    ajax: {
      url: base_url + 'admin/event/manage-event',
      type: "GET",
      data: function (d) {
        d.columns = [
          { data: 'sno' },
          { data: 'title' },
          { data: 'image' },
          { data: 'introduction' },
          { data: 'date' },
          { data: 'address' },
          { data: 'status' },
          { data: 'action' }
        ];

        d.search = {
          value: $('input[name="search"]').val()
        };
        d.status = $('select[name="status"]').val();
        d.searchDate = $('input[name="searchDate"]').val();
        d.page = eventCurrentPage;
        d.length = eventPageLength;
      }
    },
    columns: [
      { data: 'sno' },
      { data: 'title', orderable: true, searchable: true },
      { data: 'image', orderable: false, searchable: false },
      { data: 'introduction', orderable: true, searchable: true },
      { data: 'date', orderable: true },
      { data: 'address', orderable: false, searchable: false },
      { data: 'status', orderable: false, searchable: false },
      { data: 'action', orderable: false, searchable: false }
    ],
    drawCallback: function (settings) {
      updateEventPagination(settings.json);
      updateEventSortIcons(settings.json?.order);

      if (triggerSource === 'pagination' || triggerSource === 'initial') {
        $('#spinner').show();
      } else {
        $('#spinner').hide();
      }

      setTimeout(() => {
        $('#spinner').hide();
        updateEventPagination(settings.json);
        updateEventSortIcons(settings.json?.order);
      }, 100);
    }
  });

  function updateEventSortIcons(serverOrder) {
    $('#eventTable thead th').each(function (index) {
      const $th = $(this);
      $th.find('i.bi').remove();

      if (index === 0) return;

      if (serverOrder && parseInt(serverOrder.column) === index) {
        const direction = serverOrder.dir;
        const icon = direction === 'asc' ? 'bi-sort-up' : 'bi-sort-down';
        $th.append(`<i class="bi ${icon}" style="margin-left:5px;"></i>`);
      }
    });
  }

  function updateEventPagination(json) {
    const paginationUL = $('.pagination');
    paginationUL.empty();

    const totalRecords = json.recordsFiltered || 0;
    eventTotalPages = Math.ceil(totalRecords / eventPageLength);

    paginationUL.append(`
      <li class="page-item ${eventCurrentPage === 1 ? 'disabled' : ''}">
        <a class="page-link" id="eventPrevPage" style="cursor:pointer;">&laquo;</a>
      </li>
    `);

    const maxPagesToShow = 10;
    let startPage = Math.max(1, eventCurrentPage - 2);
    let endPage = Math.min(eventTotalPages, startPage + maxPagesToShow - 1);

    if (endPage - startPage < maxPagesToShow - 1) {
      startPage = Math.max(1, endPage - maxPagesToShow + 1);
    }

    for (let i = startPage; i <= endPage; i++) {
      paginationUL.append(`
        <li class="page-item ${i === eventCurrentPage ? 'active' : ''}">
          <a class="page-link event-page-link" data-page="${i}" style="cursor:pointer;">${i}</a>
        </li>
      `);
    }

    paginationUL.append(`
      <li class="page-item ${eventCurrentPage === eventTotalPages ? 'disabled' : ''}">
        <a class="page-link" id="eventNextPage" style="cursor:pointer;">&raquo;</a>
      </li>
    `);
  }

  // Pagination click
  $(document).on('click', '.event-page-link, #eventPrevPage, #eventNextPage', function (e) {
    e.preventDefault();
    const target = $(this);

    if (target.parent().hasClass('disabled') || target.parent().hasClass('active')) return;

    if (target.attr('id') === 'eventPrevPage' && eventCurrentPage > 1) {
      eventCurrentPage--;
    } else if (target.attr('id') === 'eventNextPage' && eventCurrentPage < eventTotalPages) {
      eventCurrentPage++;
    } else if (target.hasClass('event-page-link')) {
      const page = parseInt(target.data('page'));
      if (page) eventCurrentPage = page;
    }

    $('#eventTable').DataTable().ajax.reload();
  });

  // Filters
  $('#filterForm').on('submit', function (e) {
    e.preventDefault();
    eventCurrentPage = 1;
    eventTable.ajax.reload();
  });

  $('input[name="search"], select[name="status"], input[name="searchDate"]').on('change keyup', function () {
    eventCurrentPage = 1;
    eventTable.ajax.reload();
  });
});

//deleteEvent
$(document).ready(function () {
  let deleteId;

    $(document).on('click', '.btn-delete-event', function () {
      deleteId = $(this).data('id');
      const userTitle = $(this).data('title');
      $('#delete-event-title').text(userTitle);
      $('#delete-event-id').val(deleteId);
    });

    // Confirm Delete AJAX
    $('#confirm-delete-btn').on('click', function () {
      const id = $('#delete-event-id').val();

        if (!id) return;

        $('#spinner').show();

        $.ajax({
          url: base_url + "admin/deleteUser",
          method: "POST",
          contentType: "application/json",
          data: JSON.stringify({ id: id }),
          success: function (response) {
            $('#spinner').hide();
              if (response.success) {
                $('#deleteUser').modal('hide');
                  Swal.fire({
                    icon: 'success',
                    title: 'POST',
                    text: 'User has been deleted.',
                    timer: 1000,
                    showConfirmButton: false
                  });
                  $('#userTable').DataTable().ajax.reload(null, false);
              } else {
                Swal.fire({
                  icon: 'error',
                  title: 'Failed!',
                  text: response.message || 'Could not delete the user.'
                });
              }
            },
            error: function () {
                $('#spinner').hide();
                Swal.fire({
                  icon: 'error',
                  title: 'Error!',
                  text: 'Something went wrong. Please try again.'
                });
            }
        });
    });
});