let galleryCurrentPage = 1;
const galleryPageLength = 10;
let galleryTotalPages = 1;

$(document).ready(function () {
  const galleryTable = $('#galleryTable').DataTable({
    processing: true,
    serverSide: true,
    paging: false,
    searching: false,
    info: false,
    ajax: {
      url: base_url + 'admin/manage-gallery',
      type: "GET",
      data: function (d) {
        d.start = (galleryCurrentPage - 1) * galleryPageLength;
        d.length = galleryPageLength;
        d.search = {
            value: $('input[name="search"]').val()
        };
        d.searchDate = $('input[name="searchDate"]').val();
        d.searchDate = $('input[name="searchDate"]').val();
        d.columns = [
          { data: 'sno' },
          { data: 'title' },
          { data: 'category' },
          { data: 'date' },
          { data: 'image' },
            { data: 'action' }
        ];

        d.search = {
          value: $('input[name="search"]').val()
        };
        d.status = $('select[name="status"]').val();
        d.searchDate = $('input[name="searchDate"]').val();
        d.page = galleryCurrentPage;
        d.length = galleryPageLength;
      }
    },
    columns: [
      { data: 'sno' },
      { data: 'name', orderable: true, searchable: true },
      { data: 'category', orderable: true, searchable: true },
      { data: 'date', orderable: true },
      { data: 'image', orderable: false, searchable: false },
      { data: 'action', orderable: false, searchable: false }
    ],
    drawCallback: function (settings) {
      updategalleryPagination(settings.json);
      updateGallerySortIcons(settings.json?.order);

      if (triggerSource === 'pagination' || triggerSource === 'initial') {
        $('#spinner').show();
      } else {
        $('#spinner').hide();
      }

      setTimeout(() => {
        $('#spinner').hide();
        updategalleryPagination(settings.json);
        updateGallerySortIcons(settings.json?.order);
      }, 100);
    }
  });

    function updateGallerySortIcons(serverOrder) {
      $('#galleryTable thead th').each(function (index) {
        const $th = $(this);
        $th.find('i.bi').remove();

        if (index === 0) return; 

        if (serverOrder && parseInt(serverOrder.column) === index) {
          const direction = serverOrder.dir;
          const icon = direction === 'asc' ? 'bi-sort-up' : 'bi-sort-down';
          $th.append(`<i class="bi ${icon}" style="margin-left:5px;"></i>`);
        } 
      });
    }

    function updategalleryPagination(json) {
        const paginationUL = $('.pagination');
        paginationUL.empty();

        const totalRecords = json.recordsFiltered || 0;
        galleryTotalPages = Math.ceil(totalRecords / galleryPageLength);

        paginationUL.append(`
        <li class="page-item ${galleryCurrentPage === 1 ? 'disabled' : ''}">
            <a class="page-link" id="galleryPrevPage" style="cursor:pointer;">&laquo;</a>
        </li>
        `);

        const maxPagesToShow = 10;
        let startPage = Math.max(1, galleryCurrentPage - 2);
        let endPage = Math.min(galleryTotalPages, startPage + maxPagesToShow - 1);

        if (endPage - startPage < maxPagesToShow - 1) {
        startPage = Math.max(1, endPage - maxPagesToShow + 1);
        }

        for (let i = startPage; i <= endPage; i++) {
        paginationUL.append(`
            <li class="page-item ${i === galleryCurrentPage ? 'active' : ''}">
            <a class="page-link gallery-page-link" data-page="${i}" style="cursor:pointer;">${i}</a>
            </li>
        `);
        }

        paginationUL.append(`
        <li class="page-item ${galleryCurrentPage === galleryTotalPages ? 'disabled' : ''}">
            <a class="page-link" id="galleryNextPage" style="cursor:pointer;">&raquo;</a>
        </li>
        `);
    }

  // Pagination click
  $(document).on('click', '.gallery-page-link, #galleryPrevPage, #galleryNextPage', function (e) {
    e.preventDefault();
    const target = $(this);

    if (target.parent().hasClass('disabled') || target.parent().hasClass('active')) return;

    if (target.attr('id') === 'galleryPrevPage' && galleryCurrentPage > 1) {
      galleryCurrentPage--;
    } else if (target.attr('id') === 'galleryNextPage' && galleryCurrentPage < galleryTotalPages) {
      galleryCurrentPage++;
    } else if (target.hasClass('gallery-page-link')) {
      const page = parseInt(target.data('page'));
      if (page) galleryCurrentPage = page;
    }

    $('#galleryTable').DataTable().ajax.reload();
  });

  // Filters
  $('#filterForm').on('submit', function (e) {
    e.preventDefault();
    galleryCurrentPage = 1;
    galleryTable.ajax.reload();
  });

  $('input[name="search"], input[name="searchDate"]').on('change keyup', function () {
    galleryCurrentPage = 1;
    galleryTable.ajax.reload();
  });

  $(document).on('click', '.view-gallery-btn', function () {
    const galleryId = $(this).data('id');
    const title = $(this).data('title');

    $.ajax({
      url: base_url + 'admin/fetchGalleryImages',
      type: 'POST',
      data: { id: galleryId },
      dataType: 'json',
      success: function (response) {
        if (response.status === 'success') {
          $('#galleryModalLabel').text(response.title);
          $('#galleryModal .modal-body .row').html(response.images);
        } else {
          Swal.fire("Error", response.message, "error");
        }
      },
      error: function () {
        Swal.fire("Error", "Something went wrong.", "error");
      }
    });
  });

  $(document).on('click', '.delete-image-btn', function () {
    const id = $(this).data('id');
    const img = $(this).data('img');

    Swal.fire({
      title: "Are you sure?",
      text: "This image will be deleted.",
      icon: "warning",
      showCancelButton: true,
      confirmButtonText: "Yes, delete it!"
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          url: base_url + 'admin/deleteGalleryImage',
          type: 'POST',
          data: { id, img },
          success: function (res) {
            Swal.fire("Deleted!", "Image has been deleted.", "success");
            $('.view-gallery-btn[data-id="' + id + '"]').trigger('click'); // Reload modal content
          }
        });
      }
    });
  });

});

