let memberCurrentPage = 1;
const memberPageLength = 10;
let memberTotalPages = 1;

$(document).ready(function () {
  const memberTable = $('#memberTable').DataTable({
    processing: true,
    serverSide: true,
    paging: false,
    searching: false,
    info: false,
    ajax: {
        url: base_url + 'admin/manage-members',
        type: "GET",
        data: function (d) {
            d.start = (memberCurrentPage - 1) * memberPageLength;
            d.length = memberPageLength;
            d.page = memberCurrentPage;

            d.search = {
            value: $('input[name="search"]').val()
            };
            d.searchDate = $('input[name="searchDate"]').val();
            d.status = $('select[name="status"]').val();
        },
    },
    columns: [
      { data: 'sno'},
      { data: 'first_name', orderable: true, searchable: true },
      { data: 'last_name', orderable: true, searchable: true },
      { data: 'date', orderable: true },
      { data: 'email', orderable: true, searchable: true },
      { data: 'phone', orderable: false, searchable: false },
      { data: 'address', orderable: false, searchable: false },
      { data: 'action', orderable: false, searchable: false }
    ],
    drawCallback: function (settings) {
      updateMemberPagination(settings.json);
      updateMemberSortIcons(settings.json?.order);

      if (triggerSource === 'pagination' || triggerSource === 'initial') {
        $('#spinner').show();
      } else {
        $('#spinner').hide();
      }

      setTimeout(() => {
        $('#spinner').hide();
        updateMemberPagination(settings.json);
        updateMemberSortIcons(settings.json?.order);
      }, 100);
    }
  });

    function updateMemberSortIcons(serverOrder) {
      $('#memberTable thead th').each(function (index) {
        const $th = $(this);
        $th.find('i.bi').remove();

        if (index === 0) return; 

        if (serverOrder && parseInt(serverOrder.column) === index) {
          const direction = serverOrder.dir;
          const icon = direction === 'asc' ? 'bi-sort-up' : 'bi-sort-down';
          $th.append(`<i class="bi ${icon}" style="margin-left:5px;"></i>`);
        } 
      });
    }

    function updateMemberPagination(json) {
        const paginationUL = $('.pagination');
        paginationUL.empty();

        const totalRecords = json.recordsFiltered || 0;
        memberTotalPages = Math.ceil(totalRecords / memberPageLength);

        paginationUL.append(`
            <li class="page-item ${memberCurrentPage === 1 ? 'disabled' : ''}">
                <a class="page-link" id="memberPrevPage" style="cursor:pointer;">&laquo;</a>
            </li>
        `);

        const maxPagesToShow = 10;
        let startPage = Math.max(1, memberCurrentPage - 2);
        let endPage = Math.min(memberTotalPages, startPage + maxPagesToShow - 1);

        if (endPage - startPage < maxPagesToShow - 1) {
        startPage = Math.max(1, endPage - maxPagesToShow + 1);
        }

        for (let i = startPage; i <= endPage; i++) {
        paginationUL.append(`
            <li class="page-item ${i === memberCurrentPage ? 'active' : ''}">
            <a class="page-link member-page-link" data-page="${i}" style="cursor:pointer;">${i}</a>
            </li>
        `);
        }

        paginationUL.append(`
        <li class="page-item ${memberCurrentPage === memberTotalPages ? 'disabled' : ''}">
            <a class="page-link" id="memeberNextPage" style="cursor:pointer;">&raquo;</a>
        </li>
        `);
    }

  // Pagination click
  $(document).on('click', '.member-page-link, #memberPrevPage, #memeberNextPage', function (e) {
    e.preventDefault();
    const target = $(this);

    if (target.parent().hasClass('disabled') || target.parent().hasClass('active')) return;

    if (target.attr('id') === 'memberPrevPage' && memberCurrentPage > 1) {
      memberCurrentPage--;
    } else if (target.attr('id') === 'memeberNextPage' && memberCurrentPage < memberTotalPages) {
      memberCurrentPage++;
    } else if (target.hasClass('member-page-link')) {
      const page = parseInt(target.data('page'));
      if (page) memberCurrentPage = page;
    }

    $('#memberTable').DataTable().ajax.reload();
  });

  // Filters
  $('#filterForm').on('submit', function (e) {
    e.preventDefault();
    memberCurrentPage = 1;
    memberTable.ajax.reload();
  });

  $('input[name="search"], input[name="searchDate"]').on('change keyup', function () {
    memberCurrentPage = 1;
    memberTable.ajax.reload();
  });

});

// update member

 document.querySelector('#memberTable').addEventListener('click', function(e) {
      if (e.target.closest('.btn-edit-member')) {
        const button = e.target.closest('.btn-edit-member');
        document.getElementById('editMemberId').value = button.getAttribute('data-id');
        document.getElementById('edit-first-name').value = button.getAttribute('data-firstname');
        document.getElementById('edit-last-name').value = button.getAttribute('data-lastname');
        document.getElementById('edit-email').value = button.getAttribute('data-email');
        document.getElementById('edit-date').value = button.getAttribute('data-date');
        document.getElementById('edit-phone').value = button.getAttribute('data-phone');
        document.getElementById('edit-address').value = button.getAttribute('data-address');
      }
  });

  $('#update-member-form').on('submit', function(e) {
    e.preventDefault();

    $.ajax({
        url: base_url + "admin/updateMember",
        type: "POST",
        data: $(this).serialize(),
        success: function(response) {
            if (response.status === 'success') {
              $('#exampleModal').modal('hide');
              $('#memberTable').DataTable().ajax.reload(); 
              Swal.fire('Updated!', response.message, 'success');
            } else {
              Swal.fire('Error', response.message, 'error');
            }
        },
        error: function(xhr) {
            console.log(xhr.responseText);
            Swal.fire('Error', 'Could not update member.', 'error');
        }
    });
  });


//delete member
$(document).ready(function() {
      $(document).on('click', '.btn-delete-member', function() {
          let memberId = $(this).data('id');
          let memberName = $(this).data('name');

          $('#delete-member-id').val(memberId);
          $('#delete-member-title').text(memberName);
          $('#deleteMember').modal('show');
      });

      // Confirm delete
      $('#confirm-delete-btn').click(function() {
          let id = $('#delete-member-id').val();

          $.ajax({
              url: base_url + "admin/deleteMember/" + id,
              type: "Post",
              success: function(response) {
                  if (response.status === 'success') {
                      $('#deleteMember').modal('hide');
                      $('#memberTable').DataTable().ajax.reload();
                      Swal.fire('Deleted!', response.message, 'success');
                  } else {
                      Swal.fire('Error', response.message, 'error');
                  }
              },
              error: function(xhr) {
                  Swal.fire('Error', 'Could not delete member.', 'error');
              }
          });
      });
});