let userCurrentPage = 1;
const userPageLength = 10;
let userTotalPages = 1;

$(document).ready(function () {
  const userTable = $('#userTable').DataTable({
    processing: true,
    serverSide: true,
    paging: false,
    searching: false,
    info: false,
    ajax: {
      url: base_url + 'admin/manage-users',
      type: "GET",
      data: function (d) {
        d.start = (userCurrentPage - 1) * userPageLength;
        d.length = userPageLength;
        d.page = userCurrentPage;
        d.search = {
          value: $('input[name="search"]').val()
        };
      },
    },
    columns: [
      { data: 'sno'},
      { data: 'name', orderable: true, searchable: true },
      { data: 'email', orderable: true, searchable: true },
      { data: 'phone', orderable: false, searchable: false },
      { data: 'subject', orderable: false, searchable: false },
      { data: 'message', orderable: false, searchable: false },
      { data: 'action', orderable: false, searchable: false }
    ],
    drawCallback: function (settings) {
      updateUserPagination(settings.json);
      updateUserSortIcons(settings.json?.order);

      if (triggerSource === 'pagination' || triggerSource === 'initial') {
        $('#spinner').show();
      } else {
        $('#spinner').hide();
      }

      setTimeout(() => {
        $('#spinner').hide();
        updateUserPagination(settings.json);
        updateUserSortIcons(settings.json?.order);
      }, 100);
    }
  });

    function updateUserSortIcons(serverOrder) {
      $('#userTable thead th').each(function (index) {
        const $th = $(this);
        $th.find('i.bi').remove();

        if (index === 0) return; 

        if (serverOrder && parseInt(serverOrder.column) === index) {
          const direction = serverOrder.dir;
          const icon = direction === 'asc' ? 'bi-sort-up' : 'bi-sort-down';
          $th.append(`<i class="bi ${icon}" style="margin-left:5px;"></i>`);
        } 
      });
    }

    function updateUserPagination(json) {
        const paginationUL = $('.pagination');
        paginationUL.empty();

        const totalRecords = json.recordsFiltered || 0;
        userTotalPages = Math.ceil(totalRecords / userPageLength);

        paginationUL.append(`
            <li class="page-item ${userCurrentPage === 1 ? 'disabled' : ''}">
                <a class="page-link" id="userPrevPage" style="cursor:pointer;">&laquo;</a>
            </li>
        `);

        const maxPagesToShow = 10;
        let startPage = Math.max(1, userCurrentPage - 2);
        let endPage = Math.min(userTotalPages, startPage + maxPagesToShow - 1);

        if (endPage - startPage < maxPagesToShow - 1) {
        startPage = Math.max(1, endPage - maxPagesToShow + 1);
        }

        for (let i = startPage; i <= endPage; i++) {
        paginationUL.append(`
            <li class="page-item ${i === userCurrentPage ? 'active' : ''}">
            <a class="page-link user-page-link" data-page="${i}" style="cursor:pointer;">${i}</a>
            </li>
        `);
        }

        paginationUL.append(`
            <li class="page-item ${userCurrentPage === userTotalPages ? 'disabled' : ''}">
                <a class="page-link" id="userNextPage" style="cursor:pointer;">&raquo;</a>
            </li>
        `);
    }

  // Pagination click
  $(document).on('click', '.user-page-link, #userPrevPage, #userNextPage', function (e) {
    e.preventDefault();
    const target = $(this);

    if (target.parent().hasClass('disabled') || target.parent().hasClass('active')) return;

    if (target.attr('id') === 'userPrevPage' && userCurrentPage > 1) {
      userCurrentPage--;
    } else if (target.attr('id') === 'userNextPage' && userCurrentPage < userTotalPages) {
      userCurrentPage++;
    } else if (target.hasClass('user-page-link')) {
      const page = parseInt(target.data('page'));
      if (page) userCurrentPage = page;
    }

    $('#userTable').DataTable().ajax.reload();
  });

  // Filters
  $('#filterForm').on('submit', function (e) {
    e.preventDefault();
    userCurrentPage = 1;
    userTable.ajax.reload();
  });

  $('input[name="search"], input[name="searchDate"]').on('change keyup', function () {
    userCurrentPage = 1;
    userTable.ajax.reload();
  });

});

//deleteUser
$(document).ready(function () {
  let deleteId;

    $(document).on('click', '.btn-delete-user', function () {
      deleteId = $(this).data('id');
      const userTitle = $(this).data('title');
      $('#delete-user-title').text(userTitle);
      $('#delete-user-id').val(deleteId);
    });

    // Confirm Delete AJAX
    $('#confirm-delete-btn').on('click', function () {
      const id = $('#delete-user-id').val();

        if (!id) return;

        $('#spinner').show();

        $.ajax({
          url: base_url + "admin/deleteUser",
          method: "POST",
          contentType: "application/json",
          data: JSON.stringify({ id: id }),
          success: function (response) {
            $('#spinner').hide();
              if (response.success) {
                $('#deleteUser').modal('hide');
                  Swal.fire({
                    icon: 'success',
                    title: 'POST',
                    text: 'User has been deleted.',
                    timer: 1000,
                    showConfirmButton: false
                  });
                  $('#userTable').DataTable().ajax.reload(null, false);
              } else {
                Swal.fire({
                  icon: 'error',
                  title: 'Failed!',
                  text: response.message || 'Could not delete the user.'
                });
              }
            },
            error: function () {
                $('#spinner').hide();
                Swal.fire({
                  icon: 'error',
                  title: 'Error!',
                  text: 'Something went wrong. Please try again.'
                });
            }
        });
    });
});